/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator.impl;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.BinaryColorScale;
import edu.upf.bg.cutoffcmp.CutoffCmp;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class BinaryElementDecorator
extends ElementDecorator {
    private static final long serialVersionUID = 8832886601133057329L;
    private int valueIndex = this.getPropertyIndex(new String[]{"value"});
    private BinaryColorScale scale = new BinaryColorScale();
    private static final GenericFormatter fmt = new GenericFormatter("<");

    public BinaryElementDecorator() {
        this(null);
    }

    public BinaryElementDecorator(IElementAdapter adapter) {
        super(adapter);
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void setValueIndex(int valueIndex) {
        int old = this.valueIndex;
        this.valueIndex = valueIndex;
        this.firePropertyChange("propertyChanged", old, valueIndex);
    }

    public CutoffCmp getCutoffCmp() {
        return CutoffCmp.getFromName(this.scale.getComparator());
    }

    public void setCutoffCmp(CutoffCmp cutoffCmp) {
        CutoffCmp old = this.getCutoffCmp();
        this.scale.setComparator(cutoffCmp.getShortName());
        this.firePropertyChange("propertyChanged", old, cutoffCmp);
    }

    public double getCutoff() {
        return this.scale.getCutoff();
    }

    public void setCutoff(double cutoff) {
        double old = this.scale.getCutoff();
        this.scale.setCutoff(cutoff);
        this.firePropertyChange("propertyChanged", old, cutoff);
    }

    public Color getColor() {
        return this.scale.getMaxColor();
    }

    public void setColor(Color color) {
        Color old = this.scale.getMaxColor();
        this.scale.setMaxColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getNonSignificantColor() {
        return this.scale.getMinColor();
    }

    public void setNonSignificantColor(Color color) {
        Color old = this.scale.getMinColor();
        this.scale.setMinColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getEmptyColor() {
        return this.scale.getEmptyColor();
    }

    public void setEmptyColor(Color color) {
        Color old = this.scale.getEmptyColor();
        this.scale.setEmptyColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    @Override
    public void decorate(ElementDecoration decoration, Object element) {
        decoration.reset();
        Double value = element != null ? this.adapter.getValue(element, this.valueIndex) : Double.valueOf(Double.NaN);
        double v = MatrixUtils.doubleValue(value);
        if (element == null || Double.isNaN(v)) {
            decoration.setBgColor(this.scale.getEmptyColor());
            decoration.setToolTip("Empty cell");
            return;
        }
        Color c = this.scale.valueColor(v);
        decoration.setBgColor(c);
        decoration.setToolTip(fmt.format(v));
    }

    @Override
    public IColorScale getScale() {
        return this.scale;
    }
}

