/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator;

import java.util.ArrayList;
import java.util.List;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorDescriptor;
import org.gitools.model.decorator.impl.BinaryElementDecorator;
import org.gitools.model.decorator.impl.CorrelationElementDecorator;
import org.gitools.model.decorator.impl.LinearTwoSidedElementDecorator;
import org.gitools.model.decorator.impl.PValueElementDecorator;
import org.gitools.model.decorator.impl.ZScoreElementDecorator;

public class ElementDecoratorFactory {
    private static final List<ElementDecoratorDescriptor> descriptors = new ArrayList<ElementDecoratorDescriptor>();

    public static ElementDecorator create(String name, IElementAdapter adapter) {
        for (ElementDecoratorDescriptor descriptor : descriptors) {
            if (!descriptor.getName().equals(name)) continue;
            return ElementDecoratorFactory.create(descriptor, adapter);
        }
        return null;
    }

    public static ElementDecorator create(ElementDecoratorDescriptor descriptor, IElementAdapter adapter) {
        Class<? extends ElementDecorator> cls = descriptor.getDecoratorClass();
        ElementDecorator decorator = null;
        try {
            decorator = cls.getConstructor(IElementAdapter.class).newInstance(adapter);
        }
        catch (Exception e) {
            return null;
        }
        return decorator;
    }

    public static ElementDecoratorDescriptor getDescriptor(Class<? extends ElementDecorator> decoratorClass) {
        for (ElementDecoratorDescriptor desc : descriptors) {
            if (!desc.getDecoratorClass().equals(decoratorClass)) continue;
            return desc;
        }
        return null;
    }

    public static List<ElementDecoratorDescriptor> getDescriptors() {
        return descriptors;
    }

    static {
        descriptors.add(new ElementDecoratorDescriptor("Binary scale", BinaryElementDecorator.class));
        descriptors.add(new ElementDecoratorDescriptor("Linear two sided scale", LinearTwoSidedElementDecorator.class));
        descriptors.add(new ElementDecoratorDescriptor("P-Value scale", PValueElementDecorator.class));
        descriptors.add(new ElementDecoratorDescriptor("Z-Score scale", ZScoreElementDecorator.class));
        descriptors.add(new ElementDecoratorDescriptor("Correlation scale", CorrelationElementDecorator.class));
    }
}

