/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.gitools.model.ModuleMap;

public class ModuleMapFactory {
    public static ModuleMap create(String[] itemNames, Map<String, SortedSet<Integer>> moduleItemsMap, boolean includeNonMappedItems, int minModuleSize, int maxModuleSize, int[] itemsOrder) {
        int i;
        int order;
        int start;
        TreeMap<String, Integer> itemNameToRowMapping = new TreeMap<String, Integer>();
        for (int i2 = 0; i2 < itemNames.length; ++i2) {
            itemNameToRowMapping.put(itemNames[i2], i2);
        }
        boolean[] itemHasMappings = new boolean[itemNames.length];
        Set<Map.Entry<String, SortedSet<Integer>>> entries = moduleItemsMap.entrySet();
        String[] tmpModuleNames = new String[entries.size()];
        final int[][] tmpModuleItemIndices = new int[entries.size()][];
        int index = 0;
        for (Map.Entry<String, SortedSet<Integer>> entry : entries) {
            SortedSet<Integer> indices = entry.getValue();
            tmpModuleNames[index] = entry.getKey();
            tmpModuleItemIndices[index] = new int[indices.size()];
            int[] ia = tmpModuleItemIndices[index];
            int i3 = 0;
            for (Integer idx : indices) {
                ia[i3++] = idx;
                itemHasMappings[idx.intValue()] = true;
            }
            ++index;
        }
        int numModules = entries.size();
        Integer[] moduleOrder = new Integer[numModules];
        for (int i4 = 0; i4 < moduleOrder.length; ++i4) {
            moduleOrder[i4] = i4;
        }
        Arrays.sort(moduleOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int l1 = tmpModuleItemIndices[o1].length;
                int l2 = tmpModuleItemIndices[o2].length;
                return l2 - l1;
            }
        });
        int end = numModules - 1;
        for (start = 0; start < numModules && tmpModuleItemIndices[moduleOrder[start]].length > maxModuleSize; ++start) {
            order = moduleOrder[start];
            tmpModuleNames[order] = null;
            tmpModuleItemIndices[order] = null;
        }
        while (end >= start && tmpModuleItemIndices[moduleOrder[end]].length < minModuleSize) {
            order = moduleOrder[end];
            tmpModuleNames[order] = null;
            tmpModuleItemIndices[order] = null;
            --end;
        }
        numModules = ++end - start;
        String[] moduleNames = new String[numModules];
        int[][] moduleItemIndices = new int[numModules][];
        Arrays.fill(itemsOrder, -1);
        int numItems = 0;
        for (i = start; i < end; ++i) {
            int order2 = moduleOrder[i];
            moduleNames[i - start] = tmpModuleNames[order2];
            moduleItemIndices[i - start] = tmpModuleItemIndices[order2];
            int[] indices = tmpModuleItemIndices[order2];
            for (int j = 0; j < indices.length; ++j) {
                int idx = indices[j];
                if (itemsOrder[idx] < 0) {
                    itemsOrder[idx] = numItems++;
                }
                indices[j] = itemsOrder[idx];
            }
        }
        for (i = 0; i < itemsOrder.length; ++i) {
            if (itemsOrder[i] >= 0 || !includeNonMappedItems && !itemHasMappings[i]) continue;
            itemsOrder[i] = numItems++;
        }
        String[] orderedItemNames = new String[numItems];
        for (int i5 = 0; i5 < itemsOrder.length; ++i5) {
            if (itemsOrder[i5] < 0) continue;
            orderedItemNames[itemsOrder[i5]] = itemNames[i5];
        }
        ModuleMap mmap = new ModuleMap();
        mmap.setModuleNames(moduleNames);
        mmap.setItemNames(orderedItemNames);
        mmap.setAllItemIndices(moduleItemIndices);
        return mmap;
    }
}

