/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model;

import cern.colt.bitvector.BitMatrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gitools.model.Artifact;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ModuleMap
extends Artifact {
    private static final long serialVersionUID = 6463084331984782264L;
    protected String organism;
    protected String moduleCategory;
    protected String itemCategory;
    protected String[] moduleNames;
    protected String[] moduleDescriptions;
    protected String[] itemNames;
    protected int[][] itemIndices;
    protected int[][] moduleTreeIndices;
    protected Map<String, Integer> moduleIndexMap = new HashMap<String, Integer>();
    protected Map<String, Integer> itemIndexMap = new HashMap<String, Integer>();

    public ModuleMap() {
        this.moduleNames = new String[0];
        this.moduleDescriptions = new String[0];
        this.itemNames = new String[0];
        this.itemIndices = new int[0][];
        this.moduleTreeIndices = new int[0][];
    }

    public ModuleMap(String[] moduleNames, String[] itemNames, int[][] itemIndices) {
        this.setModuleNames(moduleNames);
        this.setItemNames(itemNames);
        this.itemIndices = itemIndices;
    }

    public ModuleMap(String moduleName, String[] itemNames) {
        this.setModuleNames(new String[]{moduleName});
        this.setItemNames(itemNames);
        int[] indices = new int[itemNames.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        this.setAllItemIndices(new int[][]{indices});
    }

    public ModuleMap(Map<String, Set<String>> map) {
        this(map, new HashMap<String, String>());
    }

    public ModuleMap(Map<String, Set<String>> map, Map<String, String> desc) {
        this(map, desc, new HashMap<String, Set<String>>());
    }

    public ModuleMap(Map<String, Set<String>> map, Map<String, String> desc, Map<String, Set<String>> tree) {
        int modCount = map.keySet().size();
        String[] mname = map.keySet().toArray(new String[modCount]);
        String[] mdesc = new String[modCount];
        int[][] mapIndices = new int[modCount][];
        int[][] treeIndices = new int[modCount][];
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        HashMap<String, Integer> modMap = new HashMap<String, Integer>();
        int i = 0;
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            mname[i] = entry.getKey();
            modMap.put(mname[i], i);
            mdesc[i] = desc.get(mname[i]);
            if (mdesc[i] == null) {
                mdesc[i] = "";
            }
            int[] ii = new int[entry.getValue().size()];
            int j = 0;
            for (String iname : entry.getValue()) {
                Integer idx = (Integer)itemMap.get(iname);
                if (idx == null) {
                    idx = itemMap.size();
                    itemMap.put(iname, itemMap.size());
                }
                ii[j++] = idx;
            }
            mapIndices[i] = ii;
            ++i;
        }
        HashSet<String> emptyChildren = new HashSet<String>(0);
        for (int j = 0; j < modCount; ++j) {
            Set<String> children = tree.get(mname[j]);
            if (children == null) {
                children = emptyChildren;
            }
            int[] mi = new int[children.size()];
            int k = 0;
            for (String child : children) {
                Integer idx = (Integer)modMap.get(child);
                if (idx == null) continue;
                mi[k++] = idx;
            }
            if (k < mi.length) {
                int[] tmp = new int[k];
                System.arraycopy(mi, 0, tmp, 0, k);
                mi = tmp;
            }
            treeIndices[j] = mi;
        }
        String[] inames = new String[itemMap.keySet().size()];
        for (Map.Entry entry : itemMap.entrySet()) {
            inames[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
        }
        this.setModuleNames(mname);
        this.setModuleDescriptions(mdesc);
        this.setItemNames(inames);
        this.itemIndices = mapIndices;
        this.moduleTreeIndices = treeIndices;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public String getModuleCategory() {
        return this.moduleCategory;
    }

    public void setModuleCategory(String moduleCategory) {
        this.moduleCategory = moduleCategory;
    }

    public String getItemCategory() {
        return this.itemCategory;
    }

    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }

    public String[] getModuleNames() {
        return this.moduleNames;
    }

    public final void setModuleNames(String[] moduleNames) {
        this.moduleNames = moduleNames;
        this.moduleIndexMap.clear();
        for (int i = 0; i < moduleNames.length; ++i) {
            this.moduleIndexMap.put(moduleNames[i], i);
        }
        this.itemIndices = new int[moduleNames.length][];
    }

    public String[] getModuleDescriptions() {
        return this.moduleDescriptions;
    }

    public final void setModuleDescriptions(String[] descriptions) {
        this.moduleDescriptions = descriptions;
    }

    public int getModuleCount() {
        return this.moduleNames.length;
    }

    public String getModuleName(int index) {
        return this.moduleNames[index];
    }

    public void setModuleName(int index, String name) {
        this.moduleNames[index] = name;
        this.moduleIndexMap.clear();
        for (int i = 0; i < this.moduleNames.length; ++i) {
            this.moduleIndexMap.put(this.moduleNames[i], i);
        }
    }

    public String getModuleDescription(int index) {
        return this.moduleDescriptions[index];
    }

    public void setModuleDescription(int index, String desc) {
        this.moduleDescriptions[index] = desc;
    }

    public String getModuleDescription(String name) {
        return this.getModuleDescription(this.getModuleIndex(name));
    }

    public void setModuleDescription(String name, String description) {
        this.setModuleDescription(this.getModuleIndex(name), description);
    }

    public int getModuleItemCount(int index) {
        return this.itemIndices[index].length;
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public final void setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        this.itemIndexMap.clear();
        for (int i = 0; i < itemNames.length; ++i) {
            this.itemIndexMap.put(itemNames[i], i);
        }
    }

    public int getItemCount() {
        return this.itemNames.length;
    }

    public String getItemName(int index) {
        return this.itemNames[index];
    }

    public void setItemName(int index, String name) {
        this.itemNames[index] = name;
        this.itemIndexMap.clear();
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.itemIndexMap.put(this.itemNames[i], i);
        }
    }

    public int[] getItemIndices(int moduleIndex) {
        return this.itemIndices[moduleIndex];
    }

    public void setItemIndices(int moduleIndex, int[] indices) {
        this.itemIndices[moduleIndex] = indices;
    }

    public final int[][] getAllItemIndices() {
        return this.itemIndices;
    }

    public final void setAllItemIndices(int[][] itemIndices) {
        this.itemIndices = itemIndices;
    }

    private void setModuleTreeIndices(int[][] moduleTreeIndices) {
        this.moduleTreeIndices = moduleTreeIndices;
    }

    public final ModuleMap remap(String[] names) {
        return this.remap(names, 1, Integer.MAX_VALUE);
    }

    public final ModuleMap remap(String[] names, int minSize, int maxSize) {
        HashMap<String, Integer> nameIndices = new HashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            nameIndices.put(names[i], i);
        }
        int[] indexMap = new int[this.itemNames.length];
        for (int i = 0; i < this.itemNames.length; ++i) {
            Integer index = (Integer)nameIndices.get(this.itemNames[i]);
            if (index == null) {
                index = -1;
            }
            indexMap[i] = index;
        }
        ArrayList<String> modNames = new ArrayList<String>();
        ArrayList<int[]> modIndices = new ArrayList<int[]>();
        int[] remapedIndices = null;
        for (int i = 0; i < this.itemIndices.length; ++i) {
            boolean inRange;
            int[] indices = this.itemIndices[i];
            remapedIndices = new int[indices.length];
            int numItems = 0;
            for (int j = 0; j < indices.length; ++j) {
                int newIndex;
                remapedIndices[j] = newIndex = indexMap[indices[j]];
                numItems += newIndex >= 0 ? 1 : 0;
            }
            boolean bl = inRange = numItems >= minSize && numItems <= maxSize;
            if (numItems != remapedIndices.length && inRange) {
                int[] newIndices = new int[numItems];
                int k = 0;
                for (int j = 0; j < remapedIndices.length; ++j) {
                    if (remapedIndices[j] == -1) continue;
                    newIndices[k++] = remapedIndices[j];
                }
                remapedIndices = newIndices;
            }
            if (!inRange) continue;
            modNames.add(this.moduleNames[i]);
            modIndices.add(remapedIndices);
        }
        ModuleMap mmap = new ModuleMap();
        mmap.setItemNames(names);
        mmap.setModuleNames(modNames.toArray(new String[modNames.size()]));
        mmap.setAllItemIndices((int[][])modIndices.toArray((T[])new int[modIndices.size()][]));
        mmap.setModuleTreeIndices(this.moduleTreeIndices);
        return mmap;
    }

    public Map<String, Set<String>> getMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        int modCount = this.getModuleCount();
        for (int i = 0; i < modCount; ++i) {
            int[] indices = this.itemIndices[i];
            HashSet<String> names = new HashSet<String>(indices.length);
            for (int j = 0; j < indices.length; ++j) {
                names.add(this.itemNames[indices[j]]);
            }
            map.put(this.moduleNames[i], names);
        }
        return map;
    }

    public Map<String, Set<String>> getTree() {
        HashMap<String, Set<String>> tree = new HashMap<String, Set<String>>();
        int modCount = this.getModuleCount();
        for (int i = 0; i < modCount; ++i) {
            int[] indices = this.moduleTreeIndices[i];
            HashSet<String> names = new HashSet<String>(indices.length);
            for (int j = 0; j < indices.length; ++j) {
                names.add(this.moduleNames[indices[j]]);
            }
            tree.put(this.moduleNames[i], names);
        }
        return tree;
    }

    public ModuleMap plain() {
        Map<String, Set<String>> map = this.getMap();
        Map<String, Set<String>> tree = this.getTree();
        HashMap<String, Set<String>> plainMap = new HashMap<String, Set<String>>();
        HashMap<String, String> desc = new HashMap<String, String>();
        for (String id : this.moduleNames) {
            HashSet<String> dstIds = new HashSet<String>((Collection)map.get(id));
            this.plainModule(id, new HashSet<String>(), dstIds, map, tree);
            plainMap.put(id, dstIds);
            desc.put(id, this.getModuleDescription(id));
        }
        ModuleMap mmap = new ModuleMap(plainMap, desc);
        mmap.setOrganism(this.organism);
        mmap.setModuleCategory(this.moduleCategory);
        mmap.setItemCategory(this.itemCategory);
        return mmap;
    }

    private void plainModule(String id, Set<String> path, Set<String> dstIds, Map<String, Set<String>> map, Map<String, Set<String>> childrenTree) {
        if (path.contains(id)) {
            throw new RuntimeException("Circular reference in path " + path + " for module " + id);
        }
        Set<String> childrenList = childrenTree.get(id);
        if (childrenList == null) {
            return;
        }
        for (String child : childrenList) {
            Set<String> ids = map.get(child);
            if (ids == null) continue;
            dstIds.addAll(ids);
            HashSet<String> childPath = new HashSet<String>(path);
            childPath.add(id);
            this.plainModule(child, childPath, dstIds, map, childrenTree);
        }
    }

    public BitMatrix createBitMatrix() {
        int mc = this.getModuleCount();
        int ic = this.getItemCount();
        BitMatrix map = new BitMatrix(mc, ic);
        map.xor(map);
        for (int mi = 0; mi < mc; ++mi) {
            int[] indices = this.itemIndices[mi];
            int c = indices.length;
            for (int ii = 0; ii < c; ++ii) {
                map.putQuick(mi, indices[ii], true);
            }
        }
        return map;
    }

    public int getModuleIndex(String modName) {
        Integer modIndex = this.moduleIndexMap.get(modName);
        if (modIndex == null) {
            return -1;
        }
        return modIndex;
    }

    public int[] getItemIndices(String modName) {
        Integer modIndex = this.moduleIndexMap.get(modName);
        if (modIndex == null) {
            return null;
        }
        return this.itemIndices[modIndex];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int numMods = this.moduleNames != null ? this.moduleNames.length : 0;
        sb.append(numMods).append(" modules, ");
        int numItems = this.itemNames != null ? this.itemNames.length : 0;
        sb.append(numItems).append(" items");
        return sb.toString();
    }

    public void printItemCount() {
        for (int i = 0; i < this.getModuleCount(); ++i) {
            System.out.print(this.getModuleName(i) + "\t");
            System.out.println(this.getModuleItemCount(i));
        }
    }
}

