/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import org.gitools.model.IModel;

public abstract class AbstractModel
implements IModel,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8918954049958104274L;
    public static final String PROPERTY_CHANGED = "propertyChanged";
    private transient ArrayList<PropertyChangeListener> listeners;

    public ArrayList<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList(0);
        }
        return this.listeners;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.getListeners().add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.getListeners().remove(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName) {
        for (PropertyChangeListener l : this.getListeners()) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, propName, null, null);
            l.propertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            for (PropertyChangeListener l : this.getListeners()) {
                PropertyChangeEvent evt = new PropertyChangeEvent(this, propName, oldValue, newValue);
                l.propertyChange(evt);
            }
        }
    }
}

