/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.gitools.aggregation.IAggregator;
import org.gitools.aggregation.SumAbsAggregator;
import org.gitools.label.AnnotationsPatternProvider;
import org.gitools.label.LabelProvider;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.label.MatrixRowsLabelProvider;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.filter.MatrixViewLabelFilter;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.sort.ValueSortCriteria;

public abstract class MatrixViewSorter {
    public static void sortByMutualExclusion(IMatrixView matrixView, String pattern, AnnotationMatrix am, List<String> values, boolean regExChecked, boolean applyToRows, boolean applyToColumns) {
        if (applyToRows) {
            MatrixViewSorter.sortRowsByMutualExclusion(matrixView, pattern, am, values, regExChecked);
        }
        if (applyToColumns) {
            MatrixViewSorter.sortColumnsByMutualExclusion(matrixView, pattern, am, values, regExChecked);
        }
    }

    protected static void sortRowsByMutualExclusion(final IMatrixView matrixView, String pattern, AnnotationMatrix am, List<String> values, boolean regExChecked) {
        int i;
        int i2;
        int[] selColumns = matrixView.getSelectedColumns();
        LabelProvider labelProvider = new MatrixRowsLabelProvider(matrixView);
        labelProvider = new AnnotationsPatternProvider(labelProvider, am, pattern);
        int[] visibleRows = matrixView.getVisibleRows();
        int[] selRows = MatrixViewLabelFilter.filterLabels(labelProvider, values, regExChecked, visibleRows);
        int numRows = selRows.length;
        Integer[] indices = new Integer[numRows];
        for (i2 = 0; i2 < selRows.length; ++i2) {
            indices[i2] = ArrayUtils.indexOf((int[])visibleRows, (int)selRows[i2]);
        }
        if (selColumns == null || selColumns.length == 0) {
            selColumns = new int[matrixView.getColumnCount()];
            for (i2 = 0; i2 < selColumns.length; ++i2) {
                selColumns[i2] = i2;
            }
        }
        final int[] selectedColumns = selColumns;
        final double[] valueBuffer = new double[selectedColumns.length];
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                double aggr1 = 0.0;
                double aggr2 = 0.0;
                SumAbsAggregator aggregator = new SumAbsAggregator();
                int propIndex = matrixView.getSelectedPropertyIndex();
                ValueSortCriteria.SortDirection sortDirection = ValueSortCriteria.SortDirection.DESCENDING;
                aggr1 = this.aggregateValue(matrixView, selectedColumns, idx1, propIndex, aggregator, valueBuffer);
                aggr2 = this.aggregateValue(matrixView, selectedColumns, idx2, propIndex, aggregator, valueBuffer);
                int res = (int)Math.signum(aggr1 - aggr2);
                return res * sortDirection.getFactor();
            }

            private double aggregateValue(IMatrixView matrixView2, int[] selectedColumns2, int idx, int propIndex, IAggregator aggregator, double[] valueBuffer2) {
                for (int i = 0; i < selectedColumns2.length; ++i) {
                    int col = selectedColumns2[i];
                    Object valueObject = matrixView2.getCellValue(idx, col, propIndex);
                    valueBuffer2[i] = MatrixUtils.doubleValue(valueObject);
                }
                return aggregator.aggregate(valueBuffer2);
            }
        };
        Arrays.sort(indices, comparator);
        int[] rowIndices = new int[indices.length];
        for (i = 0; i < indices.length; ++i) {
            rowIndices[i] = visibleRows[indices[i]];
        }
        for (i = 0; i < rowIndices.length; ++i) {
            int rowPos = ArrayUtils.indexOf((int[])visibleRows, (int)rowIndices[i]);
            int replacingRow = rowIndices[i];
            for (int j = i; j <= rowPos; ++j) {
                int rowToReplace = visibleRows[j];
                visibleRows[j] = replacingRow;
                replacingRow = rowToReplace;
            }
        }
        int[] sortedVisibleRows = visibleRows;
        matrixView.setVisibleRows(sortedVisibleRows);
        ValueSortCriteria[] criteriaArray = new ValueSortCriteria[1];
        int index = matrixView.getSelectedPropertyIndex();
        criteriaArray[0] = new ValueSortCriteria(index, new SumAbsAggregator(), ValueSortCriteria.SortDirection.DESCENDING);
        int i3 = numRows - 1;
        while (i3 >= 0) {
            int[] exclusiveRow = new int[]{i3--};
            MatrixViewSorter.sortColumnsByValue(matrixView, exclusiveRow, criteriaArray);
        }
    }

    private static void sortColumnsByMutualExclusion(IMatrixView matrixView, String pattern, AnnotationMatrix am, List<String> values, boolean regExChecked) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void sortByValue(IMatrixView matrixView, ValueSortCriteria[] criteria, boolean applyToRows, boolean applyToColumns) {
        if (applyToRows) {
            MatrixViewSorter.sortRowsByValue(matrixView, matrixView.getSelectedColumns(), criteria);
        }
        if (applyToColumns) {
            MatrixViewSorter.sortColumnsByValue(matrixView, matrixView.getSelectedRows(), criteria);
        }
    }

    protected static void sortRowsByValue(final IMatrixView matrixView, int[] selColumns, final ValueSortCriteria[] criteriaArray) {
        int i;
        if (criteriaArray == null || criteriaArray.length == 0) {
            return;
        }
        int numRows = matrixView.getRowCount();
        Integer[] indices = new Integer[numRows];
        for (i = 0; i < numRows; ++i) {
            indices[i] = i;
        }
        if (selColumns == null || selColumns.length == 0) {
            selColumns = new int[matrixView.getColumnCount()];
            for (i = 0; i < selColumns.length; ++i) {
                selColumns[i] = i;
            }
        }
        final int[] selectedColumns = selColumns;
        final double[] valueBuffer = new double[selectedColumns.length];
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                double aggr1 = 0.0;
                double aggr2 = 0.0;
                ValueSortCriteria criteria = null;
                for (int criteriaIndex = 0; criteriaIndex < criteriaArray.length && aggr1 == aggr2; ++criteriaIndex) {
                    criteria = criteriaArray[criteriaIndex];
                    IAggregator aggregator = criteria.getAggregator();
                    int propIndex = criteria.getAttributeIndex();
                    aggr1 = this.aggregateValue(matrixView, selectedColumns, idx1, propIndex, aggregator, valueBuffer);
                    aggr2 = this.aggregateValue(matrixView, selectedColumns, idx2, propIndex, aggregator, valueBuffer);
                }
                int res = (int)Math.signum(aggr1 - aggr2);
                return res * criteria.getDirection().getFactor();
            }

            private double aggregateValue(IMatrixView matrixView2, int[] selectedColumns2, int idx, int propIndex, IAggregator aggregator, double[] valueBuffer2) {
                for (int i = 0; i < selectedColumns2.length; ++i) {
                    int col = selectedColumns2[i];
                    Object valueObject = matrixView2.getCellValue(idx, col, propIndex);
                    valueBuffer2[i] = MatrixUtils.doubleValue(valueObject);
                }
                return aggregator.aggregate(valueBuffer2);
            }
        };
        Arrays.sort(indices, comparator);
        int[] visibleRows = matrixView.getVisibleRows();
        int[] sortedVisibleRows = new int[numRows];
        for (int i2 = 0; i2 < numRows; ++i2) {
            sortedVisibleRows[i2] = visibleRows[indices[i2]];
        }
        matrixView.setVisibleRows(sortedVisibleRows);
    }

    protected static void sortColumnsByValue(final IMatrixView matrixView, int[] selRows, final ValueSortCriteria[] criteriaArray) {
        int i;
        if (criteriaArray == null || criteriaArray.length == 0) {
            return;
        }
        int numColumns = matrixView.getColumnCount();
        Integer[] indices = new Integer[numColumns];
        for (i = 0; i < numColumns; ++i) {
            indices[i] = i;
        }
        if (selRows == null || selRows.length == 0) {
            selRows = new int[matrixView.getRowCount()];
            for (i = 0; i < selRows.length; ++i) {
                selRows[i] = i;
            }
        }
        final int[] selectedRows = selRows;
        final double[] valueBuffer = new double[selectedRows.length];
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                double aggr1 = 0.0;
                double aggr2 = 0.0;
                ValueSortCriteria criteria = null;
                for (int criteriaIndex = 0; criteriaIndex < criteriaArray.length && aggr1 == aggr2; ++criteriaIndex) {
                    criteria = criteriaArray[criteriaIndex];
                    IAggregator aggregator = criteria.getAggregator();
                    int propIndex = criteria.getAttributeIndex();
                    aggr1 = this.aggregateValue(matrixView, selectedRows, idx1, propIndex, aggregator, valueBuffer);
                    aggr2 = this.aggregateValue(matrixView, selectedRows, idx2, propIndex, aggregator, valueBuffer);
                }
                int res = (int)Math.signum(aggr1 - aggr2);
                return res * criteria.getDirection().getFactor();
            }

            private double aggregateValue(IMatrixView matrixView2, int[] selectedRows2, int idx, int propIndex, IAggregator aggregator, double[] valueBuffer2) {
                for (int i = 0; i < selectedRows2.length; ++i) {
                    int row = selectedRows2[i];
                    Object valueObject = matrixView2.getCellValue(row, idx, propIndex);
                    valueBuffer2[i] = MatrixUtils.doubleValue(valueObject);
                }
                return aggregator.aggregate(valueBuffer2);
            }
        };
        Arrays.sort(indices, comparator);
        int[] visibleColumns = matrixView.getVisibleColumns();
        int[] sortedVisibleColumns = new int[numColumns];
        for (int i2 = 0; i2 < numColumns; ++i2) {
            sortedVisibleColumns[i2] = visibleColumns[indices[i2]];
        }
        matrixView.setVisibleColumns(sortedVisibleColumns);
    }

    public static void sortByLabel(IMatrixView matrixView, boolean sortRows, ValueSortCriteria.SortDirection rowsDirection, boolean sortCols, ValueSortCriteria.SortDirection colsDirection) {
        MatrixViewSorter.sortByLabel(matrixView, sortRows, "${id}", null, rowsDirection, sortCols, "${id}", null, colsDirection);
    }

    public static void sortByLabel(IMatrixView matrixView, boolean sortRows, String rowsPattern, AnnotationMatrix rowsAnnMatrix, ValueSortCriteria.SortDirection rowsDirection, boolean sortCols, String colsPattern, AnnotationMatrix colsAnnMatrix, ValueSortCriteria.SortDirection colsDirection) {
        LabelProvider labelProvider;
        if (sortRows) {
            labelProvider = new MatrixRowsLabelProvider(matrixView);
            if (!rowsPattern.equalsIgnoreCase("${id}")) {
                labelProvider = new AnnotationsPatternProvider(labelProvider, rowsAnnMatrix, rowsPattern);
            }
            matrixView.setVisibleRows(MatrixViewSorter.sortLabels(labelProvider, rowsDirection, matrixView.getVisibleRows()));
        }
        if (sortCols) {
            labelProvider = new MatrixColumnsLabelProvider(matrixView);
            if (!colsPattern.equalsIgnoreCase("${id}")) {
                labelProvider = new AnnotationsPatternProvider(labelProvider, colsAnnMatrix, colsPattern);
            }
            matrixView.setVisibleColumns(MatrixViewSorter.sortLabels(labelProvider, colsDirection, matrixView.getVisibleColumns()));
        }
    }

    public static int[] sortLabels(final LabelProvider labelProvider, ValueSortCriteria.SortDirection direction, int[] visibleIndices) {
        int count = labelProvider.getCount();
        Integer[] indices = new Integer[count];
        for (int i = 0; i < count; ++i) {
            indices[i] = i;
        }
        final int dirSign = direction == ValueSortCriteria.SortDirection.ASCENDING ? 1 : -1;
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                String label1 = labelProvider.getLabel(idx1);
                String label2 = labelProvider.getLabel(idx2);
                return label1.compareTo(label2) * dirSign;
            }
        };
        Arrays.sort(indices, comparator);
        int[] vIndices = new int[count];
        for (int i = 0; i < count; ++i) {
            vIndices[i] = visibleIndices[indices[i]];
        }
        return vIndices;
    }
}

