/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model.element;

import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.matrix.model.element.AbstractElementAttribute;

@XmlRootElement
public class BeanElementProperty
extends AbstractElementAttribute {
    private static final long serialVersionUID = 1735870808859461498L;
    protected Method getterMethod;
    protected Method setterMethod;

    protected BeanElementProperty() {
    }

    public BeanElementProperty(String id, String name, String description, Class<?> valueClass, Method getterMethod, Method setterMethod) {
        super(id, name, description, valueClass);
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
    }

    @Override
    @XmlElement(name="Class")
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @XmlElement(name="getter")
    @XmlJavaTypeAdapter(value=MethodAdapter.class)
    public Method getGetterMethod() {
        return this.getterMethod;
    }

    @XmlElement(name="setter")
    @XmlJavaTypeAdapter(value=MethodAdapter.class)
    public Method getSetterMethod() {
        return this.setterMethod;
    }

    static class MethodAdapter
    extends XmlAdapter<String, Method> {
        MethodAdapter() {
        }

        public String marshal(Method v) throws Exception {
            String className = v.getDeclaringClass().getCanonicalName();
            Class<?> returnType = v.getReturnType();
            Class<?>[] paramTypes = v.getParameterTypes();
            Class<?> type = returnType != null ? returnType : paramTypes[0];
            return className + ":" + v.getName() + ":" + type.getCanonicalName();
        }

        public Method unmarshal(String v) throws Exception {
            String[] names = v.split(":");
            String className = names[0];
            String methodName = names[1];
            String paramClassName = names[2];
            Class<?> paramClass = Class.forName(paramClassName);
            Class<?> cls = Class.forName(className);
            return cls.getMethod(methodName, paramClass);
        }
    }
}

