/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model.element;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlRootElement;
import org.gitools.matrix.model.element.AbstractElementAdapter;
import org.gitools.matrix.model.element.AttributeDef;
import org.gitools.matrix.model.element.BeanElementProperty;
import org.gitools.matrix.model.element.IElementAttribute;

@XmlRootElement
public class BeanElementAdapter
extends AbstractElementAdapter {
    private static final long serialVersionUID = 2174377187447656241L;

    protected BeanElementAdapter() {
    }

    public BeanElementAdapter(Class<?> elementClass) {
        super(elementClass);
        this.readProperties();
    }

    @Override
    protected void setElementClass(Class<?> elementClass) {
        super.setElementClass(elementClass);
        this.readProperties();
    }

    protected void readProperties() {
        ArrayList<IElementAttribute> properties = new ArrayList<IElementAttribute>();
        for (Method m : this.elementClass.getMethods()) {
            String id;
            boolean isGet = m.getName().startsWith("get");
            if (m.getParameterTypes().length != 0 || m.getName().equals("getClass") || !isGet && !m.getName().startsWith("is")) continue;
            String getterName = isGet ? m.getName().substring(3) : m.getName().substring(2);
            Class<?> propertyClass = m.getReturnType();
            String name = id = getterName;
            String description = "";
            AttributeDef a = m.getAnnotation(AttributeDef.class);
            if (a != null) {
                if (a.id() != null) {
                    id = a.id();
                }
                if (a.name() != null) {
                    name = a.name();
                }
                if (a.description() != null) {
                    description = a.description();
                }
            }
            Method setterMethod = null;
            try {
                setterMethod = this.elementClass.getMethod("set" + getterName, propertyClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            BeanElementProperty prop = new BeanElementProperty(id, name, description, propertyClass, m, setterMethod);
            properties.add(prop);
        }
        this.setProperties(properties);
    }

    @Override
    public Object getValue(Object element, int index) {
        BeanElementProperty prop = (BeanElementProperty)this.getProperty(index);
        Method m = prop.getGetterMethod();
        Object value = null;
        try {
            value = m.invoke(element, (Object[])null);
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    @Override
    public void setValue(Object element, int index, Object value) {
        BeanElementProperty prop = (BeanElementProperty)this.getProperty(index);
        Method m = prop.getSetterMethod();
        try {
            value = m.invoke(element, value);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

