/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model.element;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlRootElement;
import org.gitools.matrix.model.element.AbstractElementAdapter;
import org.gitools.matrix.model.element.AbstractElementAttribute;
import org.gitools.matrix.model.element.IElementAttribute;

@XmlRootElement
public class ArrayElementAdapter
extends AbstractElementAdapter {
    private static final long serialVersionUID = 5864596809781257355L;
    protected String[] ids;

    protected ArrayElementAdapter() {
    }

    public ArrayElementAdapter(String[] ids) {
        super(double[].class);
        this.ids = ids;
        ArrayList<IElementAttribute> properties = new ArrayList<IElementAttribute>();
        for (String id : ids) {
            properties.add(new ArrayElementProperty(id, id, ""));
        }
        this.setProperties(properties);
    }

    @Override
    public Object getValue(Object element, int index) {
        return element != null ? Double.valueOf(((double[])element)[index]) : null;
    }

    @Override
    public void setValue(Object element, int index, Object value) {
        if (element != null) {
            ((double[])element)[index] = (Double)value;
        }
    }

    private static class ArrayElementProperty
    extends AbstractElementAttribute {
        private static final long serialVersionUID = 7803752573190009823L;

        public ArrayElementProperty(String id, String name, String description) {
            super(id, name, description, Double.TYPE);
        }
    }
}

