/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.gitools.matrix.model.element.BeanElementProperty;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;

@XmlRootElement
@XmlSeeAlso(value={BeanElementProperty.class})
public abstract class AbstractElementAdapter
implements IElementAdapter,
Serializable {
    private static final long serialVersionUID = -4797939915206004479L;
    protected Class<?> elementClass;
    private List<IElementAttribute> properties = new ArrayList<IElementAttribute>(0);
    private Map<String, Integer> propIdToIndexMap;

    public AbstractElementAdapter() {
    }

    public AbstractElementAdapter(Class<?> elementClass) {
        this.elementClass = elementClass;
    }

    @Override
    @XmlElement
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    protected void setElementClass(Class<?> elementClass) {
        this.elementClass = elementClass;
    }

    @Override
    public final int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public final IElementAttribute getProperty(int index) {
        return this.properties.get(index);
    }

    @Override
    public final List<IElementAttribute> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    protected final void setProperties(List<IElementAttribute> properties) {
        this.properties = properties;
        this.propIdToIndexMap = new HashMap<String, Integer>();
        for (int index = 0; index < properties.size(); ++index) {
            IElementAttribute prop = properties.get(index);
            this.propIdToIndexMap.put(prop.getId(), index);
        }
    }

    @Override
    public int getPropertyIndex(String id) {
        Integer index = this.propIdToIndexMap.get(id);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public abstract Object getValue(Object var1, int var2);

    @Override
    public abstract void setValue(Object var1, int var2, Object var3);
}

