/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.AbstractModel;
import org.gitools.model.xml.IndexArrayXmlAdapter;
import org.gitools.persistence.xml.adapter.PersistenceReferenceXmlAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MatrixView
extends AbstractModel
implements Serializable,
IMatrixView {
    private static final long serialVersionUID = -8602409555044803568L;
    private static final int INT_BIT_SIZE = 32;
    @XmlJavaTypeAdapter(value=PersistenceReferenceXmlAdapter.class)
    protected IMatrix contents;
    @XmlJavaTypeAdapter(value=IndexArrayXmlAdapter.class)
    protected int[] visibleRows;
    @XmlJavaTypeAdapter(value=IndexArrayXmlAdapter.class)
    protected int[] visibleColumns;
    @XmlTransient
    protected int[] selectedRows;
    @XmlTransient
    protected int[] selectedColumns;
    @XmlTransient
    protected int selectionLeadRow;
    @XmlTransient
    protected int selectionLeadColumn;
    protected int selectedPropertyIndex;
    @XmlTransient
    private int[] selectedColumnsBitmap;
    @XmlTransient
    private int[] selectedRowsBitmap;

    public MatrixView() {
        this.visibleRows = new int[0];
        this.visibleColumns = new int[0];
        this.selectedRows = new int[0];
        this.selectedColumns = new int[0];
        this.selectedColumnsBitmap = new int[0];
        this.selectedRowsBitmap = new int[0];
        this.selectionLeadColumn = -1;
        this.selectionLeadRow = -1;
    }

    public MatrixView(IMatrix contents) {
        this.initFromMatrix(contents);
    }

    public MatrixView(IMatrixView matrixView) {
        if (matrixView instanceof MatrixView) {
            this.contents = matrixView.getContents();
            this.visibleRows = matrixView.getVisibleRows();
            this.visibleColumns = matrixView.getVisibleColumns();
            this.selectedRows = matrixView.getSelectedRows();
            this.selectedColumns = matrixView.getSelectedColumns();
            this.selectionLeadRow = matrixView.getLeadSelectionRow();
            this.selectionLeadColumn = matrixView.getLeadSelectionColumn();
            this.selectedPropertyIndex = matrixView.getSelectedPropertyIndex();
        } else {
            this.initFromMatrix(matrixView.getContents());
        }
        this.selectedColumnsBitmap = this.newSelectionBitmap(this.contents.getColumnCount());
        this.selectedRowsBitmap = this.newSelectionBitmap(this.contents.getRowCount());
    }

    private void initFromMatrix(IMatrix contents) {
        int i;
        this.contents = contents;
        this.visibleRows = new int[contents.getRowCount()];
        for (i = 0; i < contents.getRowCount(); ++i) {
            this.visibleRows[i] = i;
        }
        this.visibleColumns = new int[contents.getColumnCount()];
        for (i = 0; i < contents.getColumnCount(); ++i) {
            this.visibleColumns[i] = i;
        }
        this.selectedRows = new int[0];
        this.selectedColumns = new int[0];
        this.selectedColumnsBitmap = this.newSelectionBitmap(contents.getColumnCount());
        this.selectedRowsBitmap = this.newSelectionBitmap(contents.getRowCount());
        this.selectionLeadColumn = -1;
        this.selectionLeadRow = -1;
        i = 0;
        for (IElementAttribute attr : contents.getCellAttributes()) {
            if ("right-p-value".equals(attr.getId()) || "p-value".equals(attr.getId())) {
                this.selectedPropertyIndex = i;
                break;
            }
            ++i;
        }
    }

    @Override
    public IMatrix getContents() {
        return this.contents;
    }

    @Override
    public int[] getVisibleRows() {
        return this.visibleRows;
    }

    @Override
    public void setVisibleRows(int[] indices) {
        this.setVisibleRows(indices, true);
    }

    public void setVisibleRows(int[] indices, boolean updateLead) {
        int leadRow;
        int[] selection = this.selectionFromVisible(this.selectedRowsBitmap, indices);
        int nextLeadRow = -1;
        int n = leadRow = this.selectionLeadRow >= 0 ? this.visibleRows[this.selectionLeadRow] : -1;
        if (updateLead) {
            for (int i = 0; i < indices.length && nextLeadRow == -1; ++i) {
                if (indices[i] != leadRow) continue;
                nextLeadRow = i;
            }
        }
        this.visibleRows = indices;
        this.firePropertyChange("visibleRowsChanged");
        this.setSelectedRows(selection);
        if (updateLead) {
            this.setLeadSelection(nextLeadRow, this.selectionLeadColumn);
        }
    }

    @Override
    public int[] getVisibleColumns() {
        return this.visibleColumns;
    }

    @Override
    public void setVisibleColumns(int[] indices) {
        this.setVisibleColumns(indices, true);
    }

    public void setVisibleColumns(int[] indices, boolean updateLead) {
        int leadColumn;
        int[] selection = this.selectionFromVisible(this.selectedColumnsBitmap, indices);
        int nextLeadColumn = -1;
        int n = leadColumn = this.selectionLeadColumn >= 0 ? this.visibleColumns[this.selectionLeadColumn] : -1;
        if (updateLead) {
            for (int i = 0; i < indices.length && nextLeadColumn == -1; ++i) {
                if (indices[i] != leadColumn) continue;
                nextLeadColumn = i;
            }
        }
        this.visibleColumns = indices;
        this.firePropertyChange("visibleColsChanged");
        this.setSelectedColumns(selection);
        if (updateLead) {
            this.setLeadSelection(this.selectionLeadRow, nextLeadColumn);
        }
    }

    @Override
    public void moveRowsUp(int[] indices) {
        if (indices != null && indices.length > 0) {
            Arrays.sort(indices);
            if (indices[0] > 0 && Arrays.binarySearch(indices, this.selectionLeadRow) >= 0) {
                --this.selectionLeadRow;
            }
        }
        this.arrayMoveLeft(this.visibleRows, indices, this.selectedRows);
        this.firePropertyChange("visibleRowsChanged");
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public void moveRowsDown(int[] indices) {
        if (indices != null && indices.length > 0) {
            Arrays.sort(indices);
            if (indices[indices.length - 1] < this.contents.getRowCount() - 1 && Arrays.binarySearch(indices, this.selectionLeadRow) >= 0) {
                ++this.selectionLeadRow;
            }
        }
        this.arrayMoveRight(this.visibleRows, indices, this.selectedRows);
        this.firePropertyChange("visibleRowsChanged");
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public void moveColumnsLeft(int[] indices) {
        if (indices != null && indices.length > 0) {
            Arrays.sort(indices);
            if (indices[0] > 0 && Arrays.binarySearch(indices, this.selectionLeadColumn) >= 0) {
                --this.selectionLeadColumn;
            }
        }
        this.arrayMoveLeft(this.visibleColumns, indices, this.selectedColumns);
        this.firePropertyChange("visibleColsChanged");
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public void moveColumnsRight(int[] indices) {
        if (indices != null && indices.length > 0) {
            Arrays.sort(indices);
            if (indices[indices.length - 1] < this.contents.getColumnCount() - 1 && Arrays.binarySearch(indices, this.selectionLeadColumn) >= 0) {
                ++this.selectionLeadColumn;
            }
        }
        this.arrayMoveRight(this.visibleColumns, indices, this.selectedColumns);
        this.firePropertyChange("visibleColsChanged");
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public void hideRows(int[] indices) {
        int i;
        int[] rows = this.getVisibleRows();
        int[] sel = indices;
        if (sel == null || sel.length == 0) {
            sel = this.selectionLeadRow != -1 ? new int[]{this.selectionLeadRow} : new int[]{};
        } else {
            Arrays.sort(sel);
        }
        int nextLead = sel.length > 0 ? sel[0] : -1;
        int[] vrows = new int[rows.length - sel.length];
        int j = 0;
        int k = 0;
        for (i = 0; i < rows.length && j < sel.length; ++i) {
            if (i != sel[j]) {
                vrows[k++] = rows[i];
                continue;
            }
            ++j;
        }
        while (i < rows.length) {
            vrows[k++] = rows[i++];
        }
        int count = vrows.length - 1;
        if (nextLead > count) {
            nextLead = count;
        }
        this.selectionLeadRow = nextLead;
        this.setVisibleRows(vrows, false);
        this.firePropertyChange("selectionLead");
    }

    @Override
    public void hideColumns(int[] indices) {
        int i;
        int[] columns = this.getVisibleColumns();
        int[] sel = indices;
        if (sel == null || sel.length == 0) {
            sel = this.selectionLeadColumn != -1 ? new int[]{this.selectionLeadColumn} : new int[]{};
        } else {
            Arrays.sort(sel);
        }
        int nextLead = sel.length > 0 ? sel[0] : -1;
        int[] vcolumns = new int[columns.length - sel.length];
        int j = 0;
        int k = 0;
        for (i = 0; i < columns.length && j < sel.length; ++i) {
            if (i != sel[j]) {
                vcolumns[k++] = columns[i];
                continue;
            }
            ++j;
        }
        while (i < columns.length) {
            vcolumns[k++] = columns[i++];
        }
        int count = vcolumns.length - 1;
        if (nextLead > count) {
            nextLead = count;
        }
        this.selectionLeadColumn = nextLead;
        this.setVisibleColumns(vcolumns, false);
        this.firePropertyChange("selectionLead");
    }

    @Override
    public int[] getSelectedRows() {
        return this.selectedRows;
    }

    @Override
    public void setSelectedRows(int[] indices) {
        this.selectedRows = indices;
        this.updateSelectionBitmap(this.selectedRowsBitmap, indices, this.visibleRows);
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public boolean isRowSelected(int index) {
        return this.checkSelectionBitmap(this.selectedRowsBitmap, this.visibleRows[index]);
    }

    @Override
    public int[] getSelectedColumns() {
        return this.selectedColumns;
    }

    @Override
    public void setSelectedColumns(int[] indices) {
        this.selectedColumns = indices;
        this.updateSelectionBitmap(this.selectedColumnsBitmap, indices, this.visibleColumns);
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public boolean isColumnSelected(int index) {
        return this.checkSelectionBitmap(this.selectedColumnsBitmap, this.visibleColumns[index]);
    }

    @Override
    public void selectAll() {
        if (this.selectionLeadRow == -1 && this.selectionLeadColumn != -1) {
            this.selectedColumns = new int[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.selectedColumns[i] = i;
            }
            this.selectedRows = new int[0];
            Arrays.fill(this.selectedRowsBitmap, 0);
            Arrays.fill(this.selectedColumnsBitmap, -1);
        } else {
            this.selectedRows = new int[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.selectedRows[i] = i;
            }
            this.selectedColumns = new int[0];
            Arrays.fill(this.selectedRowsBitmap, -1);
            Arrays.fill(this.selectedColumnsBitmap, 0);
        }
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public void invertSelection() {
        if (this.selectedRows.length == 0 && this.selectedColumns.length == 0) {
            this.selectAll();
        } else if (this.selectedRows.length == 0) {
            this.setSelectedColumns(this.invertSelectionArray(this.selectedColumns, this.getColumnCount()));
        } else if (this.selectedColumns.length == 0) {
            this.setSelectedRows(this.invertSelectionArray(this.selectedRows, this.getRowCount()));
        }
    }

    @Override
    public void clearSelection() {
        this.selectedColumns = new int[0];
        this.selectedRows = new int[0];
        Arrays.fill(this.selectedRowsBitmap, 0);
        Arrays.fill(this.selectedColumnsBitmap, 0);
        this.firePropertyChange("selectionChanged");
    }

    @Override
    public int getLeadSelectionRow() {
        return this.selectionLeadRow;
    }

    @Override
    public int getLeadSelectionColumn() {
        return this.selectionLeadColumn;
    }

    @Override
    public void setLeadSelection(int row, int column) {
        boolean changed = this.selectionLeadRow != row || this.selectionLeadColumn != column;
        this.selectionLeadRow = row;
        this.selectionLeadColumn = column;
        if (changed) {
            this.firePropertyChange("selectionLead");
        }
    }

    @Override
    public int getSelectedPropertyIndex() {
        return this.selectedPropertyIndex;
    }

    @Override
    public void setSelectedPropertyIndex(int index) {
        this.selectedPropertyIndex = index;
    }

    @Override
    public int getRowCount() {
        return this.visibleRows.length;
    }

    @Override
    public String getRowLabel(int index) {
        return this.contents.getRowLabel(this.visibleRows[index]);
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumns.length;
    }

    @Override
    public String getColumnLabel(int index) {
        return this.contents.getColumnLabel(this.visibleColumns[index]);
    }

    @Override
    public Object getCell(int row, int column) {
        return this.contents.getCell(this.visibleRows[row], this.visibleColumns[column]);
    }

    @Override
    public Object getCellValue(int row, int column, int index) {
        return this.contents.getCellValue(this.visibleRows[row], this.visibleColumns[column], index);
    }

    @Override
    public Object getCellValue(int row, int column, String id) {
        return this.contents.getCellValue(this.visibleRows[row], this.visibleColumns[column], id);
    }

    @Override
    public void setCellValue(int row, int column, int index, Object value) {
        this.contents.setCellValue(this.visibleRows[row], this.visibleColumns[column], index, value);
    }

    @Override
    public void setCellValue(int row, int column, String id, Object value) {
        this.contents.setCellValue(this.visibleRows[row], this.visibleColumns[column], id, value);
    }

    @Override
    public IElementAdapter getCellAdapter() {
        return this.contents.getCellAdapter();
    }

    @Override
    public List<IElementAttribute> getCellAttributes() {
        return this.contents.getCellAttributes();
    }

    @Override
    public int getCellAttributeIndex(String id) {
        return this.contents.getCellAttributeIndex(id);
    }

    private void arrayMoveLeft(int[] array, int[] indices, int[] selection) {
        if (indices.length == 0 || indices[0] == 0) {
            return;
        }
        Arrays.sort(indices);
        for (int idx : indices) {
            int tmp = array[idx - 1];
            array[idx - 1] = array[idx];
            array[idx] = tmp;
        }
        int i = 0;
        while (i < selection.length) {
            int n = i++;
            selection[n] = selection[n] - 1;
        }
    }

    private void arrayMoveRight(int[] array, int[] indices, int[] selection) {
        int i;
        if (indices.length == 0 || indices[indices.length - 1] == array.length - 1) {
            return;
        }
        Arrays.sort(indices);
        for (i = indices.length - 1; i >= 0; --i) {
            int idx = indices[i];
            int tmp = array[idx + 1];
            array[idx + 1] = array[idx];
            array[idx] = tmp;
        }
        i = 0;
        while (i < selection.length) {
            int n = i++;
            selection[n] = selection[n] + 1;
        }
    }

    private int[] invertSelectionArray(int[] array, int count) {
        int size = count - array.length;
        int[] invArray = new int[size];
        int j = 0;
        int lastIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            while (lastIndex < array[i]) {
                invArray[j++] = lastIndex++;
            }
            lastIndex = array[i] + 1;
        }
        while (lastIndex < count) {
            invArray[j++] = lastIndex++;
        }
        return invArray;
    }

    private int[] selectionFromVisible(int[] bitmap, int[] visible) {
        int selectionCount = 0;
        int[] selectionBuffer = new int[visible.length];
        for (int i = 0; i < visible.length; ++i) {
            if (!this.checkSelectionBitmap(bitmap, visible[i])) continue;
            selectionBuffer[selectionCount++] = i;
        }
        int[] selection = new int[selectionCount];
        System.arraycopy(selectionBuffer, 0, selection, 0, selectionCount);
        return selection;
    }

    private int[] newSelectionBitmap(int size) {
        int[] a = new int[(size + 32 - 1) / 32];
        Arrays.fill(a, 0);
        return a;
    }

    private void updateSelectionBitmap(int[] bitmap, int[] indices, int[] visible) {
        Arrays.fill(bitmap, 0);
        for (int visibleIndex : indices) {
            int index = visible[visibleIndex];
            int bindex = index / 32;
            int bit = 1 << index % 32;
            int n = bindex;
            bitmap[n] = bitmap[n] | bit;
        }
    }

    private boolean checkSelectionBitmap(int[] bitmap, int index) {
        int bindex = index / 32;
        int bit = 1 << index % 32;
        return (bitmap[bindex] & bit) != 0;
    }

    public void visibleColumnsFromSelection() {
        int[] sel = this.getSelectedColumns();
        int[] view = this.getVisibleColumns();
        int[] newview = new int[sel.length];
        for (int i = 0; i < newview.length; ++i) {
            newview[i] = view[sel[i]];
        }
        this.setVisibleColumns(newview);
    }

    public void visibleRowsFromSelection() {
        int[] sel = this.getSelectedRows();
        int[] view = this.getVisibleRows();
        int[] newview = new int[sel.length];
        for (int i = 0; i < newview.length; ++i) {
            newview[i] = view[sel[i]];
        }
        this.setVisibleRows(newview);
    }
}

