/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model;

import cern.colt.bitvector.BitMatrix;
import cern.colt.matrix.ObjectFactory1D;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.matrix.model.element.DoubleElementAdapter;

public class DoubleBinaryMatrix
extends BaseMatrix {
    private BitMatrix cells;
    private BitMatrix cellsNan;

    public DoubleBinaryMatrix() {
        this("", new String[0], new String[0], new BitMatrix(0, 0));
    }

    public DoubleBinaryMatrix(String title, String[] colNames, String[] rowNames, BitMatrix cells) {
        super(title, ObjectFactory1D.dense.make((Object[])rowNames), ObjectFactory1D.dense.make((Object[])colNames), new DoubleElementAdapter());
        this.cells = cells;
    }

    @Override
    public int getRowCount() {
        return this.cells.rows();
    }

    @Override
    public int getColumnCount() {
        return this.cells.columns();
    }

    @Override
    public Object getCell(int row, int column) {
        if (this.cellsNan.getQuick(column, row)) {
            return Double.NaN;
        }
        return this.cells.getQuick(column, row) ? 1.0 : 0.0;
    }

    @Override
    public Object getCellValue(int row, int column, int index) {
        return this.getCell(row, column);
    }

    @Override
    public void setCellValue(int row, int column, int index, Object value) {
        if (value != null) {
            this.cells.putQuick(column, row, (Double)value == 1.0);
            this.cellsNan.putQuick(column, row, Double.isNaN((Double)value));
        } else {
            this.cellsNan.putQuick(column, row, true);
        }
    }

    @Override
    public void makeCells(int rows, int columns) {
        this.cells = new BitMatrix(columns, rows);
        this.cells.clear();
        this.cellsNan = new BitMatrix(columns, rows);
        this.cellsNan.clear();
        if (this.rows == null || this.rows.cardinality() != rows) {
            this.setRows(ObjectFactory1D.dense.make(rows));
        }
        if (this.columns == null || this.columns.cardinality() != columns) {
            this.setColumns(ObjectFactory1D.dense.make(columns));
        }
    }
}

