/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model;

import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectMatrix1D;
import java.io.Serializable;
import java.util.List;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.Artifact;

public abstract class BaseMatrix
extends Artifact
implements IMatrix,
Serializable {
    private static final long serialVersionUID = 4021765485781500318L;
    protected ObjectMatrix1D rows;
    protected ObjectMatrix1D columns;
    protected IElementAdapter cellAdapter;

    public BaseMatrix() {
        this("", ObjectFactory1D.dense.make(0), ObjectFactory1D.dense.make(0), null);
    }

    public BaseMatrix(String title, ObjectMatrix1D rows, ObjectMatrix1D columns, IElementAdapter cellAdapter) {
        this.title = title;
        this.rows = rows;
        this.columns = columns;
        this.cellAdapter = cellAdapter;
    }

    public void make(int numRows, int numColumns) {
        this.rows = ObjectFactory1D.dense.make(numRows);
        this.columns = ObjectFactory1D.dense.make(numColumns);
        this.makeCells(numRows, numColumns);
    }

    public abstract void makeCells(int var1, int var2);

    public ObjectMatrix1D getRows() {
        return this.rows;
    }

    @Deprecated
    public String[] getRowStrings() {
        Object[] a = new String[this.rows.size()];
        this.rows.toArray(a);
        return a;
    }

    public void setRows(ObjectMatrix1D rows) {
        this.rows = rows;
    }

    public void setRows(String[] names) {
        this.rows = ObjectFactory1D.dense.make((Object[])names);
    }

    public Object getRow(int index) {
        return this.rows.get(index);
    }

    @Deprecated
    public String getRowString(int index) {
        return (String)this.rows.get(index);
    }

    @Override
    public String getRowLabel(int index) {
        return (String)this.rows.get(index);
    }

    public void setRow(int index, Object row) {
        this.rows.set(index, row);
    }

    public ObjectMatrix1D getColumns() {
        return this.columns;
    }

    @Deprecated
    public String[] getColumnStrings() {
        Object[] a = new String[this.columns.size()];
        this.columns.toArray(a);
        return a;
    }

    public void setColumns(ObjectMatrix1D columns) {
        this.columns = columns;
    }

    public void setColumns(String[] names) {
        this.columns = ObjectFactory1D.dense.make((Object[])names);
    }

    public Object getColumn(int index) {
        return this.columns.get(index);
    }

    @Deprecated
    public String getColumnString(int index) {
        return (String)this.columns.get(index);
    }

    @Override
    public String getColumnLabel(int index) {
        return (String)this.columns.get(index);
    }

    public void setColumn(int index, Object column) {
        this.columns.set(index, column);
    }

    @Override
    public Object getCellValue(int row, int column, String id) {
        return this.getCellValue(row, column, this.getCellAttributeIndex(id));
    }

    @Override
    public void setCellValue(int row, int column, String id, Object value) {
        this.setCellValue(row, column, this.getCellAttributeIndex(id), value);
    }

    @Override
    public IElementAdapter getCellAdapter() {
        return this.cellAdapter;
    }

    public void setCellAdapter(IElementAdapter cellAdapter) {
        this.cellAdapter = cellAdapter;
    }

    @Override
    public List<IElementAttribute> getCellAttributes() {
        return this.cellAdapter.getProperties();
    }

    @Override
    public int getCellAttributeIndex(String id) {
        Integer index = this.cellAdapter.getPropertyIndex(id);
        if (index == null) {
            throw new RuntimeException("There isn't any property with id: " + id);
        }
        return index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColumnCount()).append(" columns, ");
        sb.append(this.getRowCount()).append(" rows");
        return sb.toString();
    }
}

