/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.model;

import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gitools.matrix.model.StringMatrix;

@XmlAccessorType(value=XmlAccessType.NONE)
public class AnnotationMatrix
extends StringMatrix {
    private static final long serialVersionUID = 2941738380629859631L;
    private Map<String, Integer> rowMap;
    private Map<String, Integer> colMap;

    public AnnotationMatrix() {
    }

    public AnnotationMatrix(String title, ObjectMatrix1D rows, ObjectMatrix1D columns, ObjectMatrix2D cells) {
        super(title, rows, columns, cells);
        this.updateRowsMap();
        this.updateColumnsMap();
    }

    @Override
    public void setRows(ObjectMatrix1D rows) {
        super.setRows(rows);
        this.updateRowsMap();
    }

    @Override
    public void setColumns(ObjectMatrix1D columns) {
        super.setColumns(columns);
        this.updateColumnsMap();
    }

    public int getRowIndex(String id) {
        int index = -1;
        Integer idx = this.rowMap.get(id);
        if (idx != null) {
            index = idx;
        }
        return index;
    }

    public int getColumnIndex(String id) {
        int index = -1;
        Integer idx = this.colMap.get(id);
        if (idx != null) {
            index = idx;
        }
        return index;
    }

    public List<Annotation> getAnnotations(String label) {
        ArrayList<Annotation> ann = new ArrayList<Annotation>();
        int index = this.getRowIndex(label);
        if (index >= 0) {
            int numAnn = this.getColumnCount();
            for (int i = 0; i < numAnn; ++i) {
                String value = this.getCell(index, i);
                if (value == null) continue;
                String key = this.getColumnLabel(i);
                ann.add(new Annotation(key, value));
            }
        }
        return ann;
    }

    private void updateRowsMap() {
        if (this.rowMap == null) {
            this.rowMap = new HashMap<String, Integer>();
        }
        this.rowMap.clear();
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rowMap.put(this.rows.getQuick(i).toString(), i);
        }
    }

    private void updateColumnsMap() {
        if (this.colMap == null) {
            this.colMap = new HashMap<String, Integer>();
        }
        this.colMap.clear();
        for (int i = 0; i < this.columns.size(); ++i) {
            this.colMap.put(this.columns.getQuick(i).toString(), i);
        }
    }

    public static class Annotation {
        private String key;
        private String value;

        public Annotation(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

