/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.filter;

import java.util.ArrayList;
import java.util.List;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.filter.ValueFilterCriteria;
import org.gitools.matrix.model.IMatrixView;

public class MatrixViewValueFilter {
    public static void filter(IMatrixView matrixView, List<ValueFilterCriteria> criteriaList, boolean allCriteria, boolean allElements, boolean invertCriteria, boolean applyToRows, boolean applyToColumns) {
        if (applyToRows) {
            MatrixViewValueFilter.filterRows(matrixView, matrixView.getSelectedColumns(), criteriaList, allCriteria, allElements, invertCriteria);
        }
        if (applyToColumns) {
            MatrixViewValueFilter.filterColumns(matrixView, matrixView.getSelectedRows(), criteriaList, allCriteria, allElements, invertCriteria);
        }
    }

    public static void filterRows(IMatrixView matrixView, int[] selection, List<ValueFilterCriteria> criteriaList, boolean allCriteria, boolean allElements, boolean invertCriteria) {
        if (selection == null || selection.length == 0) {
            int numColumns = matrixView.getColumnCount();
            int[] sel = new int[numColumns];
            for (int i = 0; i < sel.length; ++i) {
                sel[i] = i;
            }
            selection = sel;
        }
        ArrayList<Integer> filterin = new ArrayList<Integer>();
        for (int row = 0; row < matrixView.getRowCount(); ++row) {
            boolean cellsFilterIn;
            boolean cellsAnd = true;
            boolean cellsOr = false;
            for (int col = 0; col < selection.length; ++col) {
                boolean critAnd = true;
                boolean critOr = false;
                for (int critIndex = 0; critIndex < criteriaList.size(); ++critIndex) {
                    ValueFilterCriteria criteria = criteriaList.get(critIndex);
                    double value = MatrixUtils.doubleValue(matrixView.getCellValue(row, selection[col], criteria.getAttributeIndex()));
                    boolean critRes = criteria.getComparator().compare(value, criteria.getValue());
                    critAnd &= critRes;
                    critOr |= critRes;
                }
                boolean critFilterIn = allCriteria ? critAnd : critOr;
                cellsAnd &= critFilterIn;
                cellsOr |= critFilterIn;
            }
            boolean bl = cellsFilterIn = allElements ? cellsAnd : cellsOr;
            if (invertCriteria) {
                boolean bl2 = cellsFilterIn = !cellsFilterIn;
            }
            if (!cellsFilterIn) continue;
            filterin.add(row);
        }
        int[] visibleRows = matrixView.getVisibleRows();
        int[] filterRows = new int[filterin.size()];
        for (int i = 0; i < filterin.size(); ++i) {
            filterRows[i] = visibleRows[(Integer)filterin.get(i)];
        }
        matrixView.setVisibleRows(filterRows);
    }

    public static void filterColumns(IMatrixView matrixView, int[] selection, List<ValueFilterCriteria> criteriaList, boolean allCriteria, boolean allElements, boolean invertCriteria) {
        TransposedMatrixView mv = new TransposedMatrixView(matrixView);
        MatrixViewValueFilter.filterRows(mv, selection, criteriaList, allCriteria, allElements, invertCriteria);
    }
}

