/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gitools.label.AnnotationsPatternProvider;
import org.gitools.label.LabelProvider;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.label.MatrixRowsLabelProvider;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;

public class MatrixViewLabelFilter {
    public static void filter(IMatrixView matrixView, FilterDimension dim, String pattern, AnnotationMatrix annMatrix, List<String> values, boolean useRegex) {
        LabelProvider labelProvider = null;
        switch (dim) {
            case ROWS: {
                labelProvider = new MatrixRowsLabelProvider(matrixView);
                if (!pattern.equalsIgnoreCase("${id}")) {
                    labelProvider = new AnnotationsPatternProvider(labelProvider, annMatrix, pattern);
                }
                matrixView.setVisibleRows(MatrixViewLabelFilter.filterLabels(labelProvider, values, useRegex, matrixView.getVisibleRows()));
                break;
            }
            case COLUMNS: {
                labelProvider = new MatrixColumnsLabelProvider(matrixView);
                if (!pattern.equalsIgnoreCase("${id}")) {
                    labelProvider = new AnnotationsPatternProvider(labelProvider, annMatrix, pattern);
                }
                matrixView.setVisibleColumns(MatrixViewLabelFilter.filterLabels(labelProvider, values, useRegex, matrixView.getVisibleColumns()));
            }
        }
    }

    public static int[] filterLabels(LabelProvider labelProvider, List<String> values, boolean useRegex, int[] visibleIndices) {
        LabelFilter filter = null;
        filter = useRegex ? new RegexFilter(values) : new StringFilter(values);
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        final ArrayList<Integer> matchIndices = new ArrayList<Integer>();
        int count = labelProvider.getCount();
        for (int index = 0; index < count; ++index) {
            String label = labelProvider.getLabel(index);
            int mi = filter.matchIndex(label);
            if (mi == -1) continue;
            selectedIndices.add(visibleIndices[index]);
            matchIndices.add(mi);
        }
        Integer[] sortIndices = new Integer[selectedIndices.size()];
        for (int i = 0; i < sortIndices.length; ++i) {
            sortIndices[i] = i;
        }
        Arrays.sort(sortIndices, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                int d1 = (Integer)matchIndices.get(i1);
                int d2 = (Integer)matchIndices.get(i2);
                return d1 - d2;
            }
        });
        int[] vIndices = new int[sortIndices.length];
        for (int i = 0; i < vIndices.length; ++i) {
            vIndices[i] = (Integer)selectedIndices.get(sortIndices[i]);
        }
        return vIndices;
    }

    private static class RegexFilter
    implements LabelFilter {
        private List<Pattern> patterns;

        public RegexFilter(List<String> values) {
            this.patterns = new ArrayList<Pattern>(values.size());
            for (String value : values) {
                if (value.trim().isEmpty()) continue;
                this.patterns.add(Pattern.compile(value));
            }
        }

        @Override
        public int matchIndex(String label) {
            for (int i = 0; i < this.patterns.size(); ++i) {
                Pattern pat = this.patterns.get(i);
                if (!pat.matcher(label).matches()) continue;
                return i;
            }
            return -1;
        }
    }

    private static class StringFilter
    implements LabelFilter {
        private Map<String, Integer> values = new HashMap<String, Integer>();

        public StringFilter(List<String> values) {
            for (int i = 0; i < values.size(); ++i) {
                String v = values.get(i).trim();
                if (v.isEmpty()) continue;
                this.values.put(v, i);
            }
        }

        @Override
        public int matchIndex(String label) {
            Integer index = this.values.get(label);
            return index != null ? index : -1;
        }
    }

    private static interface LabelFilter {
        public int matchIndex(String var1);
    }

    public static enum FilterDimension {
        ROWS,
        COLUMNS;

    }
}

