/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.NumericColorScale;
import edu.upf.bg.colorscale.impl.BinaryColorScale;
import edu.upf.bg.colorscale.impl.LinearTwoSidedColorScale;
import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.util.ArrayList;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.matrix.model.DoubleBinaryMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.ModuleMap;

public class MatrixUtils {
    public static int intValue(Object value) {
        int v = 0;
        if (value != null) {
            try {
                v = (Integer)value;
            }
            catch (Exception e1) {
                try {
                    v = ((Double)value).intValue();
                }
                catch (Exception e2) {
                    try {
                        v = Integer.parseInt((String)value);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
            }
        }
        return v;
    }

    @Deprecated
    public static double doubleValue(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        double v = Double.NaN;
        try {
            v = (Double)value;
        }
        catch (Exception e1) {
            try {
                v = ((Integer)value).doubleValue();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return v;
    }

    public static DoubleCast createDoubleCast(Class cls) {
        if (cls.equals(Double.class) || cls.equals(Double.TYPE)) {
            return new DoubleCast(){

                @Override
                public Double getDoubleValue(Object value) {
                    return value != null ? Double.valueOf((Double)value) : null;
                }
            };
        }
        if (cls.equals(Float.class) || cls.equals(Float.TYPE)) {
            return new DoubleCast(){

                @Override
                public Double getDoubleValue(Object value) {
                    return value != null ? Double.valueOf(((Float)value).doubleValue()) : null;
                }
            };
        }
        if (cls.equals(Integer.class) || cls.equals(Integer.TYPE)) {
            return new DoubleCast(){

                @Override
                public Double getDoubleValue(Object value) {
                    return value != null ? Double.valueOf(((Integer)value).doubleValue()) : null;
                }
            };
        }
        if (cls.equals(Long.class) || cls.equals(Long.TYPE)) {
            return new DoubleCast(){

                @Override
                public Double getDoubleValue(Object value) {
                    return value != null ? Double.valueOf(((Long)value).doubleValue()) : null;
                }
            };
        }
        return new DoubleCast(){

            @Override
            public Double getDoubleValue(Object value) {
                return value != null ? Double.valueOf(Double.NaN) : null;
            }
        };
    }

    public static IColorScale inferScale(IMatrix data, int valueIndex) {
        int numRows = data.getRowCount();
        int numCols = data.getColumnCount();
        boolean binary = true;
        double min = 0.0;
        double max = 0.0;
        DoubleCast valueCast = MatrixUtils.createDoubleCast(data.getCellAdapter().getProperty(valueIndex).getValueClass());
        for (int ri = 0; ri < numRows; ++ri) {
            for (int ci = 0; ci < numCols; ++ci) {
                Double v = valueCast.getDoubleValue(data.getCellValue(ri, ci, valueIndex));
                if (v == null) continue;
                min = v < min ? v : min;
                max = v > max ? v : max;
                binary &= Double.isNaN(v) || v == 0.0 || v == 1.0;
            }
        }
        NumericColorScale scale = null;
        if (binary) {
            BinaryColorScale bscale = new BinaryColorScale();
            bscale.setCutoff(1.0);
            bscale.setComparator(CutoffCmp.EQ.getShortName());
            scale = bscale;
        } else if (min >= 0.0 && max <= 1.0) {
            scale = new PValueColorScale();
        } else {
            LinearTwoSidedColorScale lscale = new LinearTwoSidedColorScale();
            lscale.getMin().setValue(min);
            lscale.getMax().setValue(max);
            scale = lscale;
        }
        return scale;
    }

    public static int correctedValueIndex(IElementAdapter adapter, IElementAttribute prop) {
        int numProps = adapter.getPropertyCount();
        String id = "corrected-" + prop.getId();
        for (int i = 0; i < numProps; ++i) {
            if (!id.equals(adapter.getProperty(i).getId())) continue;
            return i;
        }
        return -1;
    }

    public static BaseMatrix moduleMapToMatrix(ModuleMap mmap) {
        DoubleBinaryMatrix matrix = new DoubleBinaryMatrix();
        String[] columns = mmap.getModuleNames();
        String[] rows = mmap.getItemNames();
        matrix.setColumns(columns);
        matrix.setRows(rows);
        matrix.makeCells(rows.length, columns.length);
        for (int col = 0; col < mmap.getModuleCount(); ++col) {
            for (int row : mmap.getItemIndices(col)) {
                matrix.setCellValue(row, col, 0, (Object)1.0);
            }
        }
        return matrix;
    }

    public static ModuleMap matrixToModuleMap(IMatrix matrix) {
        String[] itemNames = new String[matrix.getRowCount()];
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            itemNames[i] = matrix.getRowLabel(i);
        }
        String[] modNames = new String[matrix.getColumnCount()];
        for (int i = 0; i < matrix.getColumnCount(); ++i) {
            modNames[i] = matrix.getColumnLabel(i);
        }
        ModuleMap map = new ModuleMap();
        map.setItemNames(itemNames);
        map.setModuleNames(modNames);
        int[][] mapIndices = new int[matrix.getColumnCount()][];
        for (int col = 0; col < matrix.getColumnCount(); ++col) {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            for (int row = 0; row < matrix.getRowCount(); ++row) {
                double value = MatrixUtils.doubleValue(matrix.getCellValue(row, col, 0));
                if (value != 1.0) continue;
                indexList.add(row);
            }
            int[] indexArray = new int[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                indexArray[i] = (Integer)indexList.get(i);
            }
            mapIndices[col] = indexArray;
        }
        map.setAllItemIndices(mapIndices);
        return map;
    }

    public static interface DoubleCast {
        public Double getDoubleValue(Object var1);
    }
}

