/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.matrix;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gitools.matrix.DiagonalMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;

public class DiagonalMatrixView
implements IMatrixView {
    private IMatrixView mv;
    private PropertyChangeListener listener;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public DiagonalMatrixView(IMatrix m) {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagonalMatrixView.this.propertyChange(evt);
            }
        };
        this.setMatrix(m);
    }

    public DiagonalMatrixView(IMatrixView mv) {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagonalMatrixView.this.propertyChange(evt);
            }
        };
        this.setMatrixView(mv);
    }

    public final void setMatrix(IMatrix matrix) {
        IMatrixView mview = matrix instanceof IMatrixView ? (IMatrixView)matrix : new MatrixView(matrix);
        this.setMatrixView(mview);
    }

    private void setMatrixView(IMatrixView mv) {
        IMatrix m;
        if (this.mv != null) {
            this.mv.removePropertyChangeListener(this.listener);
        }
        if (!((m = mv.getContents()) instanceof DiagonalMatrix)) {
            m = new DiagonalMatrix(m);
        }
        this.mv = new MatrixView(m);
        this.mv.addPropertyChangeListener(this.listener);
    }

    @Override
    public IMatrix getContents() {
        return this.mv.getContents();
    }

    @Override
    public int[] getVisibleRows() {
        return this.mv.getVisibleRows();
    }

    @Override
    public void setVisibleRows(int[] indices) {
        int[] selection = this.mv.getSelectedRows();
        this.mv.setVisibleColumns(indices);
        this.mv.setSelectedRows(selection);
        indices = Arrays.copyOf(indices, indices.length);
        this.mv.setVisibleRows(indices);
    }

    @Override
    public int[] getVisibleColumns() {
        return this.mv.getVisibleRows();
    }

    @Override
    public void setVisibleColumns(int[] indices) {
        int[] selection = this.mv.getSelectedColumns();
        this.mv.setVisibleRows(indices);
        this.mv.setSelectedColumns(selection);
        indices = Arrays.copyOf(indices, indices.length);
        this.mv.setVisibleColumns(indices);
    }

    @Override
    public void moveRowsUp(int[] indices) {
        int[] selection = this.mv.getSelectedRows();
        this.mv.moveColumnsLeft(indices);
        this.mv.setSelectedRows(selection);
        this.mv.moveRowsUp(indices);
    }

    @Override
    public void moveRowsDown(int[] indices) {
        int[] selection = this.mv.getSelectedRows();
        this.mv.moveColumnsRight(indices);
        this.mv.setSelectedRows(selection);
        this.mv.moveRowsDown(indices);
    }

    @Override
    public void moveColumnsLeft(int[] indices) {
        int[] selection = this.mv.getSelectedColumns();
        this.mv.moveRowsUp(indices);
        this.mv.setSelectedColumns(selection);
        this.mv.moveColumnsLeft(indices);
    }

    @Override
    public void moveColumnsRight(int[] indices) {
        int[] selection = this.mv.getSelectedColumns();
        this.mv.moveRowsDown(indices);
        this.mv.setSelectedColumns(selection);
        this.mv.moveColumnsRight(indices);
    }

    @Override
    public void hideRows(int[] indices) {
        this.mv.hideRows(indices);
        this.mv.hideColumns(indices);
    }

    @Override
    public void hideColumns(int[] indices) {
        this.hideRows(indices);
    }

    @Override
    public int[] getSelectedRows() {
        return this.mv.getSelectedRows();
    }

    @Override
    public void setSelectedRows(int[] indices) {
        this.mv.setSelectedRows(indices);
    }

    @Override
    public boolean isRowSelected(int index) {
        return this.mv.isRowSelected(index);
    }

    @Override
    public int[] getSelectedColumns() {
        return this.mv.getSelectedColumns();
    }

    @Override
    public void setSelectedColumns(int[] indices) {
        this.mv.setSelectedColumns(indices);
    }

    @Override
    public boolean isColumnSelected(int index) {
        return this.mv.isColumnSelected(index);
    }

    @Override
    public void selectAll() {
        this.mv.selectAll();
    }

    @Override
    public void invertSelection() {
        this.mv.invertSelection();
    }

    @Override
    public void clearSelection() {
        this.mv.clearSelection();
    }

    @Override
    public int getLeadSelectionRow() {
        return this.mv.getLeadSelectionRow();
    }

    @Override
    public int getLeadSelectionColumn() {
        return this.mv.getLeadSelectionColumn();
    }

    @Override
    public void setLeadSelection(int row, int column) {
        this.mv.setLeadSelection(row, column);
    }

    @Override
    public int getSelectedPropertyIndex() {
        return this.mv.getSelectedPropertyIndex();
    }

    @Override
    public void setSelectedPropertyIndex(int index) {
        this.mv.setSelectedPropertyIndex(index);
    }

    @Override
    public int getRowCount() {
        return this.mv.getRowCount();
    }

    @Override
    public String getRowLabel(int index) {
        return this.mv.getRowLabel(index);
    }

    @Override
    public int getColumnCount() {
        return this.mv.getColumnCount();
    }

    @Override
    public String getColumnLabel(int index) {
        return this.mv.getColumnLabel(index);
    }

    @Override
    public Object getCell(int row, int column) {
        return column >= row ? this.mv.getCell(row, column) : null;
    }

    @Override
    public Object getCellValue(int row, int column, int index) {
        return column >= row ? this.mv.getCellValue(row, column, index) : null;
    }

    @Override
    public Object getCellValue(int row, int column, String id) {
        return column >= row ? this.mv.getCellValue(row, column, id) : null;
    }

    @Override
    public void setCellValue(int row, int column, int index, Object value) {
        this.mv.setCellValue(row, column, index, value);
    }

    @Override
    public void setCellValue(int row, int column, String id, Object value) {
        this.mv.setCellValue(row, column, id, value);
    }

    @Override
    public IElementAdapter getCellAdapter() {
        return this.mv.getCellAdapter();
    }

    @Override
    public List<IElementAttribute> getCellAttributes() {
        return this.mv.getCellAttributes();
    }

    @Override
    public int getCellAttributeIndex(String id) {
        return this.mv.getCellAttributeIndex(id);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeEvent evt2 = new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt2);
        }
    }
}

