/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.idtype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gitools.idtype.IdType;
import org.gitools.idtype.UrlLink;
import org.slf4j.LoggerFactory;

public class IdTypeManager {
    private static IdTypeManager instance;
    private List<IdType> idTypes;
    private Map<String, IdType> idTypesMap;
    private IdType defaultIdType;

    public static IdTypeManager getDefault() {
        if (instance == null) {
            instance = IdTypeManager.createDefaultInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IdTypeManager createDefaultInstance() {
        ArrayList<IdType> idTypes = new ArrayList<IdType>();
        Reader reader = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Document.class});
            Unmarshaller u = context.createUnmarshaller();
            reader = new InputStreamReader(IdTypeManager.class.getResourceAsStream("/idtypes.xml"));
            Document doc = (Document)u.unmarshal(reader);
            idTypes.addAll(doc.idTypes);
        }
        catch (JAXBException ex) {
            LoggerFactory.getLogger(IdTypeManager.class).error(ex.toString());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new IdTypeManager(idTypes);
    }

    private IdTypeManager(List<IdType> idTypes) {
        this.idTypes = idTypes;
        this.idTypesMap = new HashMap<String, IdType>();
        for (IdType type : idTypes) {
            this.idTypesMap.put(type.getKey(), type);
        }
        this.defaultIdType = this.idTypesMap.get("not_specified");
        if (this.defaultIdType == null) {
            this.defaultIdType = new IdType("not_specified", "Not specified");
            this.idTypes.add(this.defaultIdType);
            this.idTypesMap.put(this.defaultIdType.getKey(), this.defaultIdType);
        }
    }

    public List<IdType> getIdTypes() {
        return Collections.unmodifiableList(this.idTypes);
    }

    public IdType getIdType(String idTypeKey) {
        return this.idTypesMap.get(idTypeKey);
    }

    public IdType getDefaultIdType() {
        return this.defaultIdType;
    }

    public List<UrlLink> getLinks(String idTypeKey) {
        IdType type = this.idTypesMap.get(idTypeKey);
        if (type == null) {
            return new ArrayList<UrlLink>(0);
        }
        return Collections.unmodifiableList(type.getLinks());
    }

    @XmlRootElement(name="idTypes")
    private static class Document {
        @XmlElement(name="idType")
        public List<IdType> idTypes = new ArrayList<IdType>(0);

        private Document() {
        }
    }
}

