/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.idmapper;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gitools.idmapper.Mapper;
import org.gitools.idmapper.MappingContext;
import org.gitools.idmapper.MappingData;
import org.gitools.idmapper.MappingException;
import org.gitools.idmapper.MappingNode;
import org.gitools.idmapper.StringMappingNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEngine {
    private static final Logger logger = LoggerFactory.getLogger(MappingEngine.class);
    private MappingContext context = new MappingContext();
    private List<Edge> edges = new ArrayList<Edge>();

    public MappingContext getContext() {
        return this.context;
    }

    public void addMapper(String src, String dst, Mapper proc) {
        this.addMapper(new StringMappingNode(src), new StringMappingNode(dst), proc);
    }

    public void addMapper(MappingNode src, MappingNode dst, Mapper proc) {
        this.edges.add(new Edge(src, dst, proc));
    }

    public MappingData run(String[] ids, String src, String dst, IProgressMonitor monitor) throws MappingException {
        monitor.begin("Mapping from " + src + " to " + dst + " ...", 4);
        MappingData data = new MappingData(src, src);
        if (ids != null) {
            data.identity(new HashSet<String>(Arrays.asList(ids)));
        }
        monitor.info("Searching mapping path ...");
        Path path = this.findPath(src, dst, monitor);
        if (path == null) {
            throw new MappingException("Unable to find a mapping path from " + src + " to " + dst);
        }
        monitor.debug("Mapping path: " + path);
        monitor.worked(1);
        LinkedList<Step> steps = path.getSteps();
        Iterator it = steps.iterator();
        HashSet<Mapper> initializedMappers = new HashSet<Mapper>();
        it.next();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            Mapper mapper = step.getMapper();
            if (initializedMappers.contains(mapper)) continue;
            mapper.initialize(this.context, monitor);
            initializedMappers.add(mapper);
        }
        monitor.worked(1);
        it = steps.iterator();
        MappingNode lastNode = ((Step)it.next()).getNode();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            IProgressMonitor iProgressMonitor = monitor.subtask();
            iProgressMonitor.begin("Mapping from " + lastNode + " to " + step.getNode() + " ...", 1);
            data = step.getMapper().map(this.context, data, lastNode, step.getNode(), iProgressMonitor.subtask());
            lastNode = step.getNode();
            data.setDstNode(lastNode);
            data.removeEmptyKeys();
            iProgressMonitor.end();
        }
        monitor.worked(1);
        for (Mapper mapper : initializedMappers) {
            mapper.finalize(this.context, monitor);
        }
        monitor.end();
        return data;
    }

    public MappingData run(String src, String dst, IProgressMonitor monitor) throws MappingException {
        return this.run(null, src, dst, monitor);
    }

    private Path findPath(String src, String dst, IProgressMonitor monitor) {
        StringMappingNode dstNode = new StringMappingNode(dst);
        Path bestPath = null;
        int bestLength = Integer.MAX_VALUE;
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.offer(new Path(new StringMappingNode(src)));
        block0: while (paths.size() > 0) {
            Path path = (Path)paths.poll();
            if (path.getLength() >= bestLength) continue;
            MappingNode snode = path.getLastNode();
            boolean generatorRequired = path.getLength() == 0;
            List<Step> steps = this.getSteps(snode, generatorRequired);
            for (Step step : steps) {
                if (step.getNode().equals(dstNode)) {
                    if (bestPath != null) continue;
                    bestPath = new Path(path, step);
                    bestLength = bestPath.getLength();
                    continue block0;
                }
                if (path.visited(step.getNode())) continue;
                paths.add(new Path(path, step));
            }
        }
        return bestPath;
    }

    private List<Step> getSteps(MappingNode snode, boolean generatorRequired) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Edge edge : this.edges) {
            MappingNode src = edge.getSrc();
            MappingNode dst = edge.getDst();
            Mapper mapper = edge.getMapper();
            if (generatorRequired && !mapper.isGenerator()) continue;
            if (src.equals(snode)) {
                steps.add(new Step(dst, mapper));
                continue;
            }
            if (!mapper.isBidirectional() || !dst.equals(snode)) continue;
            steps.add(new Step(src, mapper));
        }
        return steps;
    }

    private static class Step {
        private MappingNode node;
        private Mapper mapper;

        public Step(MappingNode node) {
            this(node, null);
        }

        public Step(MappingNode node, Mapper mapper) {
            this.node = node;
            this.mapper = mapper;
        }

        public MappingNode getNode() {
            return this.node;
        }

        public Mapper getMapper() {
            return this.mapper;
        }

        public String toString() {
            return this.node.getId() + " {" + this.mapper.getName() + "}";
        }
    }

    private static class Path {
        private LinkedList<Step> steps = new LinkedList();
        private Set<MappingNode> visited = new HashSet<MappingNode>();

        public Path() {
        }

        public Path(MappingNode node) {
            this.steps.add(new Step(node));
        }

        private Path(Path path, Step step) {
            this.steps.addAll(path.getSteps());
            this.steps.add(step);
        }

        public MappingNode getLastNode() {
            return this.steps.getLast().getNode();
        }

        public void addStep(Step step) {
            this.steps.add(step);
            this.visited.add(step.getNode());
        }

        public int getLength() {
            return this.steps.size() - 1;
        }

        public LinkedList<Step> getSteps() {
            return this.steps;
        }

        private boolean visited(MappingNode node) {
            return this.visited.contains(node);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.steps.iterator();
            if (it.hasNext()) {
                Step step = (Step)it.next();
                sb.append(step.getNode());
                while (it.hasNext()) {
                    step = (Step)it.next();
                    sb.append(" --[").append(step.getMapper());
                    sb.append("]--> ").append(step.getNode());
                }
            }
            return sb.toString();
        }
    }

    private static class Edge {
        private MappingNode src;
        private MappingNode dst;
        private Mapper proc;

        public Edge(MappingNode src, MappingNode dst, Mapper proc) {
            this.src = src;
            this.dst = dst;
            this.proc = proc;
        }

        public MappingNode getSrc() {
            return this.src;
        }

        public MappingNode getDst() {
            return this.dst;
        }

        public Mapper getMapper() {
            return this.proc;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)obj;
            return this.src.equals(other.getSrc()) && this.dst.equals(other.getDst());
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.src != null ? this.src.hashCode() : 0);
            hash = 67 * hash + (this.dst != null ? this.dst.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.src.toString() + " --> " + this.dst.toString();
        }
    }
}

