/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.idmapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gitools.idmapper.MappingNode;
import org.gitools.idmapper.StringMappingNode;

public class MappingData {
    private MappingNode srcNode;
    private MappingNode dstNode;
    private Set<String> dstIds;
    private Map<String, Set<String>> map;

    public MappingData(String srcId, String dstId) {
        this.srcNode = new StringMappingNode(srcId);
        this.dstNode = new StringMappingNode(dstId);
        this.dstIds = new HashSet<String>();
        this.map = new HashMap<String, Set<String>>();
    }

    public MappingNode getSrcNode() {
        return this.srcNode;
    }

    public MappingNode getDstNode() {
        return this.dstNode;
    }

    public void setDstNode(MappingNode dstNode) {
        this.dstNode = dstNode;
    }

    public Set<String> getSrcIds() {
        return this.map.keySet();
    }

    public Set<String> getDstIds() {
        return this.dstIds;
    }

    public Set<String> get(String srcId) {
        Set<String> d = this.map.get(srcId);
        if (d == null) {
            d = new HashSet<String>();
        }
        return d;
    }

    public void put(String srcId, String dstId) {
        Set<String> ids = this.map.get(srcId);
        if (ids == null) {
            ids = new HashSet<String>();
            this.map.put(srcId, ids);
        }
        this.dstIds.add(dstId);
        ids.add(dstId);
    }

    public void clearDstIds() {
        this.dstIds.clear();
    }

    public void set(String srcId, Set<String> dids) {
        this.map.put(srcId, dids);
        this.dstIds.addAll(dids);
    }

    public Map<String, Set<String>> getMap() {
        return this.map;
    }

    public void map(Map<String, Set<String>> dstmap) {
        this.clearDstIds();
        for (Map.Entry<String, Set<String>> e : this.map.entrySet()) {
            HashSet<String> dset = new HashSet<String>();
            for (String sname : e.getValue()) {
                Set<String> dnames = dstmap.get(sname);
                if (dnames == null) continue;
                dset.addAll(dnames);
            }
            this.set(e.getKey(), dset);
        }
    }

    public void clear() {
        this.dstIds.clear();
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.keySet().isEmpty();
    }

    public void identity(Set<String> set) {
        this.clear();
        for (String id : set) {
            this.put(id, id);
        }
    }

    public void removeEmptyKeys() {
        ArrayList<String> rm = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> e : this.map.entrySet()) {
            if (!e.getValue().isEmpty()) continue;
            rm.add(e.getKey());
        }
        for (String k : rm) {
            this.map.remove(k);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.map.size()).append(" keys, ");
        sb.append(this.dstIds.size()).append(" distinct values. ");
        sb.append(this.map.toString());
        return sb.toString();
    }
}

