/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.util;

import edu.upf.bg.cutoffcmp.CutoffCmp;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.DoubleBinaryMatrix;
import org.gitools.matrix.model.DoubleMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorFactory;
import org.gitools.model.decorator.impl.BinaryElementDecorator;

public class HeatmapUtil {
    public static Heatmap createFromMatrixView(IMatrixView matrixView) {
        Heatmap figure = new Heatmap(matrixView);
        int propertiesNb = figure.getMatrixView().getCellAdapter().getPropertyCount();
        while (matrixView.getContents() instanceof MatrixView) {
            matrixView = (IMatrixView)matrixView.getContents();
        }
        IMatrix matrix = matrixView.getContents();
        if (matrix instanceof DoubleBinaryMatrix) {
            ElementDecorator[] decorators = new BinaryElementDecorator[propertiesNb];
            for (int i = 0; i < decorators.length; ++i) {
                BinaryElementDecorator decorator = (BinaryElementDecorator)ElementDecoratorFactory.create("Binary scale", matrix.getCellAdapter());
                decorator.setValueIndex(i);
                decorator.setCutoff(1.0);
                decorator.setCutoffCmp(CutoffCmp.EQ);
                decorators[i] = decorator;
            }
            figure.setCellDecorators(decorators);
            figure.getRowDim().setGridEnabled(false);
            figure.getColumnDim().setGridEnabled(false);
        } else if (matrix instanceof DoubleMatrix) {
            ElementDecorator[] decorators = new ElementDecorator[propertiesNb];
            for (int i = 0; i < decorators.length; ++i) {
                ElementDecorator decorator = ElementDecoratorFactory.create("P-Value scale", matrix.getCellAdapter());
                decorator.setValueIndex(i);
                decorators[i] = decorator;
            }
            figure.setCellDecorators(decorators);
            figure.getRowDim().setGridEnabled(false);
            figure.getColumnDim().setGridEnabled(false);
        } else if (matrix instanceof ObjectMatrix) {
            ElementDecorator[] decorators = new ElementDecorator[propertiesNb];
            for (int i = 0; i < decorators.length; ++i) {
                ElementDecorator decorator = ElementDecoratorFactory.create("P-Value scale", matrix.getCellAdapter());
                decorator.setValueIndex(i);
                decorators[i] = decorator;
            }
            figure.setCellDecorators(decorators);
        }
        return figure;
    }
}

