/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.header;

import edu.upf.bg.xml.adapter.ColorXmlAdapter;
import edu.upf.bg.xml.adapter.FontXmlAdapter;
import java.awt.Color;
import java.awt.Font;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.matrix.model.AnnotationMatrix;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HeatmapTextLabelsHeader
extends HeatmapHeader {
    private static final long serialVersionUID = -2580139666999968074L;
    public static final String FG_COLOR_CHANGED = "fgColorChanged";
    public static final String FONT_CHANGED = "fontChanged";
    public static final String LABEL_PATTERN_CHANGED = "labelPatternChanged";
    public static final String LINK_NAME_CHANGED = "linkNameChanged";
    public static final String LINK_PATTERN_CHANGED = "linkPatternChanged";
    @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
    protected Color foregroundColor;
    @XmlJavaTypeAdapter(value=FontXmlAdapter.class)
    protected Font font;
    protected LabelSource labelSource;
    protected String labelAnnotation;
    protected String labelPattern;
    @Deprecated
    protected String linkName;
    @Deprecated
    protected String linkPattern;

    public HeatmapTextLabelsHeader() {
        this(null);
    }

    public HeatmapTextLabelsHeader(HeatmapDim hdim) {
        super(hdim);
        AnnotationMatrix am;
        this.size = 80;
        this.foregroundColor = Color.BLACK;
        this.backgroundColor = Color.WHITE;
        this.font = new Font("Monospaced", 0, 9);
        AnnotationMatrix annotationMatrix = am = hdim != null ? hdim.getAnnotations() : null;
        if (am != null && am.getColumnCount() > 0) {
            this.labelSource = LabelSource.ANNOTATION;
            this.labelAnnotation = am.getColumnLabel(0);
        } else {
            this.labelSource = LabelSource.ID;
            this.labelAnnotation = "";
        }
        this.labelPattern = "${id}";
        this.linkName = "Google";
        this.linkPattern = "http://www.google.com/search?q=${url:id}";
    }

    @Override
    public String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append("Text: ");
        switch (this.labelSource) {
            case ID: {
                sb.append("ID");
                break;
            }
            case ANNOTATION: {
                sb.append(this.labelAnnotation);
                break;
            }
            case PATTERN: {
                sb.append(this.labelPattern);
            }
        }
        return sb.toString();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        Color old = this.foregroundColor;
        this.foregroundColor = color;
        this.firePropertyChange(FG_COLOR_CHANGED, old, color);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        Font old = this.font;
        this.font = font;
        this.firePropertyChange(FONT_CHANGED, old, font);
    }

    public LabelSource getLabelSource() {
        return this.labelSource;
    }

    public void setLabelSource(LabelSource labelSource) {
        this.labelSource = labelSource;
    }

    public String getLabelAnnotation() {
        return this.labelAnnotation;
    }

    public void setLabelAnnotation(String labelAnnotation) {
        this.labelAnnotation = labelAnnotation;
    }

    public String getLabelPattern() {
        return this.labelPattern;
    }

    public void setLabelPattern(String pattern) {
        String old = this.labelPattern;
        this.labelPattern = pattern;
        this.firePropertyChange(LABEL_PATTERN_CHANGED, old, pattern);
    }

    @Deprecated
    public String getLinkName() {
        return this.linkName;
    }

    @Deprecated
    public void setLinkName(String linkName) {
        String old = this.linkName;
        this.linkName = linkName;
        this.firePropertyChange(LINK_NAME_CHANGED, old, linkName);
    }

    @Deprecated
    public String getLinkPattern() {
        return this.linkPattern;
    }

    @Deprecated
    public void setLinkPattern(String linkPattern) {
        String old = this.linkPattern;
        this.linkPattern = linkPattern;
        this.firePropertyChange(LINK_PATTERN_CHANGED, old, linkPattern);
    }

    public static enum LabelSource {
        ID,
        ANNOTATION,
        PATTERN;

    }
}

