/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.header;

import edu.upf.bg.xml.adapter.ColorXmlAdapter;
import java.awt.Color;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.model.AbstractModel;

public abstract class HeatmapHeader
extends AbstractModel {
    public static final String TITLE_CHANGED = "title";
    public static final String SIZE_CHANGED = "size";
    public static final String VISIBLE_CHANGED = "visible";
    public static final String BG_COLOR_CHANGED = "bgColor";
    protected String title;
    protected int size;
    protected boolean visible;
    @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
    protected Color backgroundColor;
    @XmlTransient
    protected HeatmapDim dim;

    public HeatmapHeader(HeatmapDim dim) {
        this.dim = dim;
        this.title = "";
        this.size = 100;
        this.visible = true;
        this.backgroundColor = Color.WHITE;
    }

    public HeatmapDim getHeatmapDim() {
        return this.dim;
    }

    public void setHeatmapDim(HeatmapDim dim) {
        this.dim = dim;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_CHANGED, old, title);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        int old = this.size;
        this.size = size;
        this.firePropertyChange(SIZE_CHANGED, old, size);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean old = this.visible;
        this.visible = visible;
        this.firePropertyChange(VISIBLE_CHANGED, old, visible);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        Color old = this.backgroundColor;
        this.backgroundColor = color;
        this.firePropertyChange(BG_COLOR_CHANGED, old, color);
    }
}

