/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.header;

import edu.upf.bg.color.generator.ColorGenerator;
import edu.upf.bg.color.generator.ColorGeneratorFactory;
import edu.upf.bg.xml.adapter.ColorXmlAdapter;
import edu.upf.bg.xml.adapter.FontXmlAdapter;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.clustering.ClusteringResults;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapHeader;

public class HeatmapColoredLabelsHeader
extends HeatmapHeader {
    public static final String THICKNESS_CHANGED = "thickness";
    public static final String MARGIN_CHANGED = "margin";
    public static final String SEPARATION_GRID_CHANGED = "separationGrid";
    public static final String LABEL_VISIBLE_CHANGED = "labelVisible";
    public static final String LABEL_FONT_CHANGED = "labelFont";
    public static final String LABEL_ROTATED_CHANGED = "labelRotated";
    public static final String LABEL_COLOR_DEFINED_CHANGED = "labelColorDefined";
    public static final String LABEL_COLOR_CHANGED = "labelColor";
    public static final String CLUSTERS_CHANGED = "clusters";
    public static final String INDICES_CHANGED = "indices";
    protected int thickness;
    protected int margin;
    protected boolean separationGrid;
    protected boolean labelVisible;
    @XmlJavaTypeAdapter(value=FontXmlAdapter.class)
    protected Font font;
    protected boolean labelRotated;
    protected boolean labelColorDefined;
    @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
    protected Color labelColor;
    protected ColoredLabel[] coloredLabels;
    protected Map<String, Integer> dataColoredLabelIndices;

    public HeatmapColoredLabelsHeader(HeatmapDim hdim) {
        super(hdim);
        this.size = 20;
        this.thickness = 14;
        this.margin = 1;
        this.separationGrid = true;
        this.labelVisible = false;
        this.font = new Font("Monospaced", 0, 9);
        this.labelRotated = false;
        this.labelColorDefined = false;
        this.labelColor = Color.BLACK;
        this.coloredLabels = new ColoredLabel[0];
        this.dataColoredLabelIndices = new HashMap<String, Integer>();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        int old = this.thickness;
        this.thickness = thickness;
        this.firePropertyChange(THICKNESS_CHANGED, old, thickness);
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        int old = this.margin;
        this.margin = margin;
        this.firePropertyChange(MARGIN_CHANGED, old, margin);
    }

    public boolean isSeparationGrid() {
        return this.separationGrid;
    }

    public void setSeparationGrid(boolean separationGrid) {
        boolean old = this.separationGrid;
        this.separationGrid = separationGrid;
        this.firePropertyChange(SEPARATION_GRID_CHANGED, old, separationGrid);
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean labelVisible) {
        boolean old = this.labelVisible;
        this.labelVisible = labelVisible;
        this.firePropertyChange(LABEL_VISIBLE_CHANGED, old, labelVisible);
    }

    public Font getLabelFont() {
        return this.font;
    }

    public void setLabelFont(Font font) {
        Font old = this.font;
        this.font = font;
        this.firePropertyChange(LABEL_FONT_CHANGED, old, font);
    }

    public boolean isLabelRotated() {
        return this.labelRotated;
    }

    public void setLabelRotated(boolean labelRotated) {
        boolean old = this.labelRotated;
        this.labelRotated = labelRotated;
        this.firePropertyChange(LABEL_ROTATED_CHANGED, old, labelRotated);
    }

    public boolean isLabelColorDefined() {
        return this.labelColorDefined;
    }

    public void setLabelColorDefined(boolean labelColorDefined) {
        boolean old = this.labelColorDefined;
        this.labelColorDefined = labelColorDefined;
        this.firePropertyChange(LABEL_COLOR_DEFINED_CHANGED, old, labelColorDefined);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        Color old = this.labelColor;
        this.labelColor = labelColor;
        this.firePropertyChange(LABEL_COLOR_CHANGED, old, labelColor);
    }

    public ColoredLabel[] getClusters() {
        return this.coloredLabels;
    }

    public void setClusters(ColoredLabel[] clusters) {
        ColoredLabel[] old = this.coloredLabels;
        this.coloredLabels = clusters;
        this.firePropertyChange(CLUSTERS_CHANGED, old, clusters);
    }

    public ColoredLabel getAssignedColoredLabel(String id) {
        Integer index = this.dataColoredLabelIndices.get(id);
        if (index == null) {
            return null;
        }
        return this.coloredLabels[index];
    }

    public void setAssignedColoredLabels(Map<String, Integer> assigned) {
        this.dataColoredLabelIndices = new HashMap<String, Integer>(assigned);
        this.firePropertyChange(INDICES_CHANGED);
    }

    public Map<String, Integer> getAssignedColoredLabels() {
        return this.dataColoredLabelIndices;
    }

    public void setAssignedColoredLabel(String id, int clusterIndex) {
        ColoredLabel old = this.getAssignedColoredLabel(id);
        if (old != null && clusterIndex == -1) {
            this.dataColoredLabelIndices.remove(id);
        } else {
            this.dataColoredLabelIndices.put(id, clusterIndex);
        }
        ColoredLabel newCluster = clusterIndex != -1 ? this.coloredLabels[clusterIndex] : null;
        this.firePropertyChange(INDICES_CHANGED, old, newCluster);
    }

    public void clearAssignedColoredLabels() {
        this.dataColoredLabelIndices.clear();
        this.firePropertyChange(INDICES_CHANGED);
    }

    public void updateFromClusterResults(ClusteringResults results) {
        ColorGenerator cg = ColorGeneratorFactory.getDefault().create();
        String[] clusterTitles = results.getClusterTitles();
        this.coloredLabels = new ColoredLabel[results.getNumClusters()];
        for (int i = 0; i < results.getNumClusters(); ++i) {
            ColoredLabel cluster = this.coloredLabels[i] = new ColoredLabel();
            cluster.setName(clusterTitles[i]);
            cluster.setColor(cg.next());
        }
        this.dataColoredLabelIndices = new HashMap<String, Integer>();
        for (String label : results.getDataLabels()) {
            this.dataColoredLabelIndices.put(label, results.getClusterIndex(label));
        }
    }

    public class ColoredLabel {
        protected String name;
        @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
        protected Color color;

        public ColoredLabel() {
            this.name = "";
            this.color = Color.WHITE;
        }

        public ColoredLabel(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }
}

