/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.drawer.header;

import edu.upf.bg.color.utils.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.drawer.AbstractHeatmapHeaderDrawer;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.label.AnnotationsPatternProvider;
import org.gitools.label.LabelProvider;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.label.MatrixLabelProvider;
import org.gitools.label.MatrixRowsLabelProvider;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;

public class HeatmapTextLabelsDrawer
extends AbstractHeatmapHeaderDrawer<HeatmapTextLabelsHeader> {
    public HeatmapTextLabelsDrawer(Heatmap heatmap, HeatmapTextLabelsHeader header, boolean horizontal) {
        super(heatmap, header, horizontal);
    }

    @Override
    public void draw(Graphics2D g, Rectangle box, Rectangle clip) {
        g.setColor(((HeatmapTextLabelsHeader)this.header).getBackgroundColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.heatmap.isShowBorders()) {
            int borderSize = this.getBorderSize();
            g.setColor(Color.BLACK);
            g.drawRect(box.x, box.y, box.width - 1, box.height - 1);
            box.x = box.x + (this.horizontal ? 0 : borderSize);
            box.width = box.width - borderSize * (this.horizontal ? 1 : 2);
            box.y += borderSize;
            box.height = box.height - borderSize * (this.horizontal ? 1 : 2);
        }
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        IMatrixView data = this.heatmap.getMatrixView();
        g.setFont(((HeatmapTextLabelsHeader)this.header).getFont());
        Color gridColor = hdim.getGridColor();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int maxWidth = clip.width;
        int width = ((HeatmapTextLabelsHeader)this.header).getSize();
        int cellHeight = this.horizontal ? this.heatmap.getCellWidth() : this.heatmap.getCellHeight();
        int height = cellHeight + gridSize;
        width = width < maxWidth ? maxWidth : width;
        int clipStart = clip.y - box.y;
        int clipEnd = clipStart + clip.height;
        int count = this.horizontal ? data.getColumnCount() : data.getRowCount();
        int start = (clipStart - height) / height;
        int end = (clipEnd + height - 1) / height;
        start = start > 0 ? start : 0;
        end = end < count ? end : count;
        LineMetrics lm = ((HeatmapTextLabelsHeader)this.header).getFont().getLineMetrics("y\u00cd;|", g.getFontRenderContext());
        float fontHeight = lm.getHeight();
        float fontDesc = lm.getDescent();
        int fontOffset = (int)Math.ceil((fontHeight + (float)cellHeight) / 2.0f - fontDesc);
        int leadRow = data.getLeadSelectionRow();
        int leadColumn = data.getLeadSelectionColumn();
        MatrixLabelProvider matrixLabelProvider = null;
        matrixLabelProvider = this.horizontal ? new MatrixColumnsLabelProvider(this.heatmap.getMatrixView()) : new MatrixRowsLabelProvider(this.heatmap.getMatrixView());
        LabelProvider labelProvider = null;
        switch (((HeatmapTextLabelsHeader)this.header).getLabelSource()) {
            case ID: {
                labelProvider = matrixLabelProvider;
                break;
            }
            case ANNOTATION: {
                labelProvider = new AnnotationProvider(matrixLabelProvider, hdim.getAnnotations(), ((HeatmapTextLabelsHeader)this.header).getLabelAnnotation());
                break;
            }
            case PATTERN: {
                labelProvider = new AnnotationsPatternProvider(matrixLabelProvider, hdim.getAnnotations(), ((HeatmapTextLabelsHeader)this.header).getLabelPattern());
            }
        }
        int x = box.x;
        int y = box.y + start * height;
        int padding = 2;
        for (int index = start; index < end; ++index) {
            boolean selected;
            Color bgColor = ((HeatmapTextLabelsHeader)this.header).getBackgroundColor();
            Color fgColor = ((HeatmapTextLabelsHeader)this.header).getForegroundColor();
            Color gColor = gridColor;
            String label = labelProvider.getLabel(index);
            String matrixLabel = matrixLabelProvider.getLabel(index);
            if (hdim.isHighlighted(matrixLabel)) {
                bgColor = highlightingColor;
            }
            boolean bl = !this.pictureMode && (this.horizontal ? data.isColumnSelected(index) : data.isRowSelected(index)) ? true : (selected = false);
            if (selected) {
                bgColor = bgColor.darker();
                fgColor = fgColor.darker();
                gColor = gridColor.darker();
            }
            boolean lead = !this.pictureMode && (this.horizontal ? leadColumn == index : leadRow == index);
            g.setColor(gColor);
            g.fillRect(x, y + cellHeight, width, gridSize);
            g.setColor(bgColor);
            g.fillRect(x, y, width, cellHeight);
            if (lead) {
                g.setColor(ColorUtils.invert(bgColor));
                g.drawRect(x, y, width, cellHeight - 1);
            }
            if (fontHeight <= (float)cellHeight) {
                g.setColor(fgColor);
                g.drawString(label, x + padding, y + fontOffset);
            }
            y += height;
        }
    }

    @Override
    public Dimension getSize() {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int extBorder = 0;
        if (this.horizontal) {
            int cellWidth = this.heatmap.getCellWidth() + gridSize;
            int columnCount = this.heatmap.getMatrixView().getColumnCount();
            int headerSize = ((HeatmapTextLabelsHeader)this.header).getSize();
            return new Dimension(cellWidth * columnCount + extBorder, headerSize);
        }
        int cellHeight = this.heatmap.getCellHeight() + gridSize;
        int rowCount = this.heatmap.getMatrixView().getRowCount();
        int headerSize = ((HeatmapTextLabelsHeader)this.header).getSize();
        return new Dimension(headerSize, cellHeight * rowCount + extBorder);
    }

    @Override
    public HeatmapPosition getPosition(Point p) {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int row = -1;
        int col = -1;
        if (this.horizontal) {
            int cellSize = this.heatmap.getCellWidth() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getColumnCount();
            if (p.x >= 0 && p.x < totalSize) {
                col = p.x / cellSize;
            }
        } else {
            int cellSize = this.heatmap.getCellHeight() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getRowCount();
            if (p.y >= 0 && p.y < totalSize) {
                row = p.y / cellSize;
            }
        }
        return new HeatmapPosition(row, col);
    }

    @Override
    public Point getPoint(HeatmapPosition p) {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int x = 0;
        int y = 0;
        if (this.horizontal) {
            int cellSize = this.heatmap.getCellWidth() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getColumnCount();
            int n = x = p.column >= 0 ? p.column * cellSize : 0;
            if (x > totalSize) {
                x = totalSize;
            }
        } else {
            int cellSize = this.heatmap.getCellHeight() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getRowCount();
            int n = y = p.row >= 0 ? p.row * cellSize : 0;
            if (y > totalSize) {
                y = totalSize;
            }
        }
        return new Point(x, y);
    }

    protected static class AnnotationProvider
    implements LabelProvider {
        private LabelProvider labelProvider;
        private AnnotationMatrix am;
        private String name;
        private int column;

        public AnnotationProvider(LabelProvider labelProvider, AnnotationMatrix am, String name) {
            this.labelProvider = labelProvider;
            this.am = am;
            this.name = name;
            if (am != null) {
                this.column = am.getColumnIndex(name);
            }
        }

        @Override
        public int getCount() {
            return this.labelProvider.getCount();
        }

        @Override
        public String getLabel(int index) {
            if (this.am == null) {
                return this.name;
            }
            String label = this.labelProvider.getLabel(index);
            int row = this.am.getRowIndex(label);
            if (row == -1) {
                return "";
            }
            if (this.column == -1) {
                return "";
            }
            return this.am.getCell(row, this.column);
        }
    }
}

