/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.drawer.header;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.AbstractHeatmapDrawer;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.heatmap.drawer.header.HeatmapColoredLabelsDrawer;
import org.gitools.heatmap.drawer.header.HeatmapTextLabelsDrawer;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;

public class HeatmapHeaderDrawer
extends AbstractHeatmapDrawer {
    private boolean horizontal;
    private List<AbstractHeatmapDrawer> drawers;
    protected static final double radianAngle90 = -1.5707963267948966;

    public HeatmapHeaderDrawer(Heatmap heatmap, boolean horizontal) {
        super(heatmap);
        this.horizontal = horizontal;
        this.updateDrawers();
    }

    public final void updateDrawers() {
        List<HeatmapHeader> headers = this.horizontal ? this.heatmap.getColumnDim().getHeaders() : this.heatmap.getRowDim().getHeaders();
        this.drawers = new ArrayList<AbstractHeatmapDrawer>(headers.size());
        for (int i = 0; i < headers.size(); ++i) {
            HeatmapHeader h = headers.get(i);
            if (!h.isVisible()) continue;
            AbstractHeatmapDrawer d = null;
            if (h instanceof HeatmapTextLabelsHeader) {
                d = new HeatmapTextLabelsDrawer(this.heatmap, (HeatmapTextLabelsHeader)h, this.horizontal);
            } else if (h instanceof HeatmapColoredLabelsHeader) {
                d = new HeatmapColoredLabelsDrawer(this.heatmap, (HeatmapColoredLabelsHeader)h, this.horizontal);
            }
            if (d == null) continue;
            d.setPictureMode(this.pictureMode);
            this.drawers.add(d);
        }
    }

    @Override
    public Dimension getSize() {
        int w = 0;
        int h = 0;
        if (this.horizontal) {
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                if (sz.width > w) {
                    w = sz.width;
                }
                h += sz.height;
            }
        } else {
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                if (sz.height > h) {
                    h = sz.height;
                }
                w += sz.width;
            }
        }
        return new Dimension(w, h);
    }

    @Override
    public void draw(Graphics2D g, Rectangle box, Rectangle clip) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.horizontal) {
            int x = box.y;
            int y = box.x;
            int totalSize = box.height;
            Rectangle clip2 = new Rectangle(clip.y, clip.x, clip.height, clip.width);
            g.rotate(-1.5707963267948966);
            g.translate(-totalSize, 0);
            g.fillRect(box.x, box.y, box.width, box.height);
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                Rectangle box2 = new Rectangle(x, y, sz.height, sz.width);
                d.draw(g, box2, clip2.intersection(box2));
                x += box2.width;
            }
        } else {
            int x = box.x;
            int y = box.y;
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                Rectangle box2 = new Rectangle(x, y, sz.width, sz.height);
                d.draw(g, box2, clip.intersection(box2));
                x += sz.width;
            }
        }
    }

    @Override
    public HeatmapPosition getPosition(Point p) {
        int x = 0;
        int y = 0;
        if (this.horizontal) {
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                Rectangle box2 = new Rectangle(x, y, sz.width, sz.height);
                if (box2.contains(p)) {
                    p.translate(-x, -y);
                    return d.getPosition(p);
                }
                y += sz.height;
            }
        } else {
            for (AbstractHeatmapDrawer d : this.drawers) {
                Dimension sz = d.getSize();
                Rectangle box2 = new Rectangle(x, y, sz.width, sz.height);
                if (box2.contains(p)) {
                    p.translate(-x, -y);
                    return d.getPosition(p);
                }
                x += sz.width;
            }
        }
        return new HeatmapPosition(0, 0);
    }

    @Override
    public Point getPoint(HeatmapPosition p) {
        return new Point(0, 0);
    }

    @Override
    public void setPictureMode(boolean pictureMode) {
        for (AbstractHeatmapDrawer d : this.drawers) {
            d.setPictureMode(pictureMode);
        }
    }
}

