/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.drawer.header;

import edu.upf.bg.color.utils.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.drawer.AbstractHeatmapHeaderDrawer;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.label.MatrixLabelProvider;
import org.gitools.label.MatrixRowsLabelProvider;
import org.gitools.matrix.model.IMatrixView;

public class HeatmapColoredLabelsDrawer
extends AbstractHeatmapHeaderDrawer<HeatmapColoredLabelsHeader> {
    private int headerTotalSize = 0;

    public HeatmapColoredLabelsDrawer(Heatmap heatmap, HeatmapColoredLabelsHeader header, boolean horizontal) {
        super(heatmap, header, horizontal);
    }

    @Override
    public void draw(Graphics2D g, Rectangle box, Rectangle clip) {
        g.setColor(((HeatmapColoredLabelsHeader)this.header).getBackgroundColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        IMatrixView data = this.heatmap.getMatrixView();
        g.setFont(((HeatmapColoredLabelsHeader)this.header).getLabelFont());
        Color gridColor = hdim.getGridColor();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int maxWidth = clip.width;
        int width = ((HeatmapColoredLabelsHeader)this.header).getSize();
        int height = (this.horizontal ? this.heatmap.getCellWidth() : this.heatmap.getCellHeight()) + gridSize;
        width = width < maxWidth ? maxWidth : width;
        int clipStart = clip.y - box.y;
        int clipEnd = clipStart + clip.height;
        int count = this.horizontal ? data.getColumnCount() : data.getRowCount();
        int start = (clipStart - height) / height;
        int end = (clipEnd + height - 1) / height;
        start = start > 0 ? start : 0;
        end = end < count ? end : count;
        int fontHeight = g.getFontMetrics().getHeight();
        int fontOffset = (fontHeight + height - gridSize) / 2 - 1;
        int leadRow = data.getLeadSelectionRow();
        int leadColumn = data.getLeadSelectionColumn();
        MatrixLabelProvider labelProvider = null;
        labelProvider = this.horizontal ? new MatrixColumnsLabelProvider(this.heatmap.getMatrixView()) : new MatrixRowsLabelProvider(this.heatmap.getMatrixView());
        HeatmapColoredLabelsHeader.ColoredLabel lastCluster = null;
        int x = box.x;
        int y = box.y + start * height;
        for (int index = start; index < end; ++index) {
            boolean selected;
            Color clusterColor;
            Color bgColor = ((HeatmapColoredLabelsHeader)this.header).getBackgroundColor();
            Color finalGridColor = gridColor;
            String label = labelProvider.getLabel(index);
            HeatmapColoredLabelsHeader.ColoredLabel cluster = ((HeatmapColoredLabelsHeader)this.header).getAssignedColoredLabel(label);
            Color color = clusterColor = cluster != null ? cluster.getColor() : bgColor;
            if (hdim.isHighlighted(label)) {
                bgColor = highlightingColor;
            }
            boolean bl = !this.pictureMode && (this.horizontal ? data.isColumnSelected(index) : data.isRowSelected(index)) ? true : (selected = false);
            if (selected) {
                bgColor = bgColor.darker();
                clusterColor = clusterColor.darker();
                finalGridColor = gridColor.darker();
            }
            boolean lead = !this.pictureMode && (this.horizontal ? leadColumn == index : leadRow == index);
            g.setColor(bgColor);
            g.fillRect(x, y, width, height - gridSize);
            g.setColor(finalGridColor);
            g.fillRect(x, y + height - gridSize, width, gridSize);
            if (cluster != null) {
                int thickness;
                int sepSize = 0;
                if (((HeatmapColoredLabelsHeader)this.header).isSeparationGrid() && lastCluster != null && !cluster.equals(lastCluster)) {
                    sepSize = ((HeatmapColoredLabelsHeader)this.header).getMargin();
                }
                if ((thickness = ((HeatmapColoredLabelsHeader)this.header).getSize() - ((HeatmapColoredLabelsHeader)this.header).getMargin() * 2) < 1) {
                    thickness = 1;
                }
                g.setColor(clusterColor);
                g.fillRect(x + ((HeatmapColoredLabelsHeader)this.header).getMargin(), y + sepSize, thickness, height);
            }
            if (lead) {
                g.setColor(ColorUtils.invert(bgColor));
                g.drawRect(x, y, width, height - gridSize - 1);
            }
            lastCluster = cluster;
            y += height;
        }
    }

    @Override
    public Dimension getSize() {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int extBorder = 0;
        HeatmapDim dim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        this.headerTotalSize = ((HeatmapColoredLabelsHeader)this.header).getSize();
        if (this.horizontal) {
            int cellWidth = this.heatmap.getCellWidth() + gridSize;
            int columnCount = this.heatmap.getMatrixView().getColumnCount();
            return new Dimension(cellWidth * columnCount + extBorder, this.headerTotalSize);
        }
        int cellHeight = this.heatmap.getCellHeight() + gridSize;
        int rowCount = this.heatmap.getMatrixView().getRowCount();
        return new Dimension(this.headerTotalSize, cellHeight * rowCount + extBorder);
    }

    @Override
    public HeatmapPosition getPosition(Point p) {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int row = -1;
        int col = -1;
        if (this.horizontal) {
            int cellSize = this.heatmap.getCellWidth() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getColumnCount();
            if (p.x >= 0 && p.x < totalSize) {
                col = p.x / cellSize;
            }
        } else {
            int cellSize = this.heatmap.getCellHeight() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getRowCount();
            if (p.y >= 0 && p.y < totalSize) {
                row = p.y / cellSize;
            }
        }
        return new HeatmapPosition(row, col);
    }

    @Override
    public Point getPoint(HeatmapPosition p) {
        HeatmapDim hdim = this.horizontal ? this.heatmap.getColumnDim() : this.heatmap.getRowDim();
        int gridSize = hdim.isGridEnabled() ? hdim.getGridSize() : 0;
        int x = 0;
        int y = 0;
        if (this.horizontal) {
            int cellSize = this.heatmap.getCellWidth() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getColumnCount();
            int n = x = p.column >= 0 ? p.column * cellSize : 0;
            if (x > totalSize) {
                x = totalSize;
            }
        } else {
            int cellSize = this.heatmap.getCellHeight() + gridSize;
            int totalSize = cellSize * this.heatmap.getMatrixView().getRowCount();
            int n = y = p.row >= 0 ? p.row * cellSize : 0;
            if (y > totalSize) {
                y = totalSize;
            }
        }
        return new Point(x, y);
    }
}

