/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.drawer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.AbstractHeatmapDrawer;
import org.gitools.heatmap.drawer.HeatmapBodyDrawer;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.heatmap.drawer.header.HeatmapHeaderDrawer;

public class HeatmapDrawer
extends AbstractHeatmapDrawer {
    private HeatmapBodyDrawer body;
    private final HeatmapHeaderDrawer rowsHeader;
    private final HeatmapHeaderDrawer colsHeader;

    public HeatmapDrawer(Heatmap heatmap) {
        super(heatmap);
        this.body = new HeatmapBodyDrawer(heatmap);
        this.rowsHeader = new HeatmapHeaderDrawer(heatmap, false);
        this.colsHeader = new HeatmapHeaderDrawer(heatmap, true);
    }

    @Override
    public void draw(Graphics2D g, Rectangle box, Rectangle clip) {
        Dimension bodySize = this.body.getSize();
        Dimension rowsSize = this.rowsHeader.getSize();
        Dimension columnsSize = this.colsHeader.getSize();
        Rectangle columnsBounds = new Rectangle(0, 0, columnsSize.width, columnsSize.height);
        Rectangle bodyBounds = new Rectangle(0, columnsSize.height, bodySize.width, bodySize.height);
        Rectangle rowsBounds = new Rectangle(bodySize.width, columnsSize.height, rowsSize.width, rowsSize.height);
        AffineTransform at = new AffineTransform();
        this.colsHeader.draw(g, columnsBounds, columnsBounds);
        at.setToIdentity();
        g.setTransform(at);
        this.body.draw(g, bodyBounds, bodyBounds);
        at.setToIdentity();
        g.setTransform(at);
        this.rowsHeader.draw(g, rowsBounds, rowsBounds);
        at.setToIdentity();
        g.setTransform(at);
    }

    @Override
    public Dimension getSize() {
        Dimension bodySize = this.body.getSize();
        Dimension rowsSize = this.rowsHeader.getSize();
        Dimension columnsSize = this.colsHeader.getSize();
        return new Dimension(bodySize.width + rowsSize.width, bodySize.height + columnsSize.height);
    }

    @Override
    public HeatmapPosition getPosition(Point p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Point getPoint(HeatmapPosition p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPictureMode(boolean pictureMode) {
        super.setPictureMode(pictureMode);
        this.body.setPictureMode(pictureMode);
        this.rowsHeader.setPictureMode(pictureMode);
        this.colsHeader.setPictureMode(pictureMode);
    }
}

