/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap.drawer;

import edu.upf.bg.color.utils.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.AbstractHeatmapDrawer;
import org.gitools.heatmap.drawer.HeatmapPosition;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class HeatmapBodyDrawer
extends AbstractHeatmapDrawer {
    public HeatmapBodyDrawer(Heatmap heatmap) {
        super(heatmap);
    }

    @Override
    public void draw(Graphics2D g, Rectangle box, Rectangle clip) {
        int borderSize = this.getBorderSize();
        int rowsGridSize = this.heatmap.getRowDim().isGridEnabled() ? this.heatmap.getRowDim().getGridSize() : 0;
        int columnsGridSize = this.heatmap.getColumnDim().isGridEnabled() ? this.heatmap.getColumnDim().getGridSize() : 0;
        g.setColor(Color.WHITE);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.heatmap.isShowBorders()) {
            g.setColor(Color.BLACK);
            g.drawRect(box.x, box.y, box.width - 1, box.height - 1);
            box.grow(-borderSize, -borderSize);
        }
        IMatrixView data = this.heatmap.getMatrixView();
        int cellWidth = this.heatmap.getCellWidth() + columnsGridSize;
        int cellHeight = this.heatmap.getCellHeight() + rowsGridSize;
        int rowStart = (clip.y - box.y) / cellHeight;
        int rowEnd = (clip.y - box.y + clip.height + cellHeight - 1) / cellHeight;
        rowEnd = rowEnd < data.getRowCount() ? rowEnd : data.getRowCount();
        int colStart = (clip.x - box.x) / cellWidth;
        int colEnd = (clip.x - box.x + clip.width + cellWidth - 1) / cellWidth;
        colEnd = colEnd < data.getColumnCount() ? colEnd : data.getColumnCount();
        ElementDecorator deco = this.heatmap.getActiveCellDecorator();
        ElementDecoration decoration = new ElementDecoration();
        int leadRow = this.heatmap.getMatrixView().getLeadSelectionRow();
        int leadColumn = this.heatmap.getMatrixView().getLeadSelectionColumn();
        int y = box.y + rowStart * cellHeight;
        for (int row = rowStart; row < rowEnd; ++row) {
            int x = box.x + colStart * cellWidth;
            boolean rowSelected = data.isRowSelected(row);
            for (int col = colStart; col < colEnd; ++col) {
                boolean selected;
                Object element = data.getCell(row, col);
                deco.decorate(decoration, element);
                Color color = decoration.getBgColor();
                Color rowsGridColor = this.heatmap.getRowDim().getGridColor();
                Color columnsGridColor = this.heatmap.getColumnDim().getGridColor();
                boolean bl = selected = !this.pictureMode && (rowSelected || data.isColumnSelected(col));
                if (selected) {
                    color = color.darker();
                    rowsGridColor = rowsGridColor.darker();
                    columnsGridColor = columnsGridColor.darker();
                }
                g.setColor(color);
                g.fillRect(x, y, cellWidth - columnsGridSize, cellHeight - rowsGridSize);
                g.setColor(rowsGridColor);
                g.fillRect(x, y + cellHeight - rowsGridSize, cellWidth, rowsGridSize);
                g.setColor(columnsGridColor);
                g.fillRect(x + cellWidth - columnsGridSize, y, columnsGridSize, cellWidth - columnsGridSize);
                if (!this.pictureMode) {
                    int y2;
                    int x2;
                    if (row == leadRow && col == leadColumn) {
                        g.setColor(ColorUtils.invert(color));
                        g.drawRect(x, y, cellWidth - columnsGridSize - 1, cellHeight - rowsGridSize - 1);
                    } else if (row == leadRow && col != leadColumn) {
                        g.setColor(ColorUtils.invert(color));
                        x2 = x + cellWidth - columnsGridSize - 1;
                        y2 = y + cellHeight - rowsGridSize - 1;
                        g.drawLine(x, y, x2, y);
                        g.drawLine(x, y2, x2, y2);
                    } else if (row != leadRow && col == leadColumn) {
                        g.setColor(ColorUtils.invert(color));
                        x2 = x + cellWidth - columnsGridSize - 1;
                        y2 = y + cellHeight - rowsGridSize - 1;
                        g.drawLine(x, y, x, y2);
                        g.drawLine(x2, y, x2, y2);
                    }
                }
                x += cellWidth;
            }
            y += cellHeight;
        }
    }

    @Override
    public Dimension getSize() {
        int rowsGridSize = this.heatmap.getRowDim().isGridEnabled() ? this.heatmap.getRowDim().getGridSize() : 0;
        int columnsGridSize = this.heatmap.getColumnDim().isGridEnabled() ? this.heatmap.getColumnDim().getGridSize() : 0;
        int cellWidth = this.heatmap.getCellWidth() + columnsGridSize;
        int cellHeight = this.heatmap.getCellHeight() + rowsGridSize;
        int rowCount = this.heatmap.getMatrixView().getRowCount();
        int columnCount = this.heatmap.getMatrixView().getColumnCount();
        int extBorder = 0;
        return new Dimension(cellWidth * columnCount + extBorder, cellHeight * rowCount + extBorder);
    }

    @Override
    public HeatmapPosition getPosition(Point p) {
        int rowsGridSize = this.heatmap.getRowDim().isGridEnabled() ? this.heatmap.getRowDim().getGridSize() : 0;
        int columnsGridSize = this.heatmap.getColumnDim().isGridEnabled() ? this.heatmap.getColumnDim().getGridSize() : 0;
        int extBorder = 0;
        int cellHeight = this.heatmap.getCellHeight() + rowsGridSize;
        int rowCount = this.heatmap.getMatrixView().getRowCount();
        int totalHeight = cellHeight * rowCount + extBorder;
        int cellWidth = this.heatmap.getCellWidth() + columnsGridSize;
        int columnCount = this.heatmap.getMatrixView().getColumnCount();
        int totalWidth = cellWidth * columnCount + extBorder;
        int row = p.y >= 0 && p.y < totalHeight ? (p.y - extBorder) / cellHeight : -1;
        int column = p.x >= 0 && p.x < totalWidth ? (p.x - extBorder) / cellWidth : -1;
        return new HeatmapPosition(row, column);
    }

    @Override
    public Point getPoint(HeatmapPosition p) {
        int y;
        int x;
        int rowsGridSize = this.heatmap.getRowDim().isGridEnabled() ? this.heatmap.getRowDim().getGridSize() : 0;
        int columnsGridSize = this.heatmap.getColumnDim().isGridEnabled() ? this.heatmap.getColumnDim().getGridSize() : 0;
        int extBorder = 0;
        int cellHeight = this.heatmap.getCellHeight() + rowsGridSize;
        int rowCount = this.heatmap.getMatrixView().getRowCount();
        int totalHeight = cellHeight * rowCount + extBorder;
        int cellWidth = this.heatmap.getCellWidth() + columnsGridSize;
        int columnCount = this.heatmap.getMatrixView().getColumnCount();
        int totalWidth = cellWidth * columnCount + extBorder;
        int n = x = p.column >= 0 ? p.column * cellWidth : 0;
        if (x > totalWidth) {
            x = totalWidth;
        }
        int n2 = y = p.row >= 0 ? p.row * cellHeight : 0;
        if (y > totalHeight) {
            y = totalHeight;
        }
        return new Point(x, y);
    }
}

