/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap;

import edu.upf.bg.xml.adapter.ColorXmlAdapter;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.idtype.IdType;
import org.gitools.idtype.IdTypeManager;
import org.gitools.idtype.IdTypeXmlAdapter;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.model.AbstractModel;
import org.gitools.persistence.xml.adapter.PersistenceReferenceXmlAdapter;

public class HeatmapDim
extends AbstractModel {
    public static final String IDTYPE_CHANGED = "idType";
    public static final String HEADERS_CHANGED = "headers";
    public static final String HEADER_SIZE_CHANGED = "headerSize";
    public static final String CLUSTER_SETS_CHANGED = "clusterSets";
    public static final String GRID_PROPERTY_CHANGED = "gridProperty";
    public static final String ANNOTATIONS_CHANGED = "annotations";
    public static final String HIGHLIGHTING_CHANGED = "highlighting";
    @XmlJavaTypeAdapter(value=IdTypeXmlAdapter.class)
    protected IdType idType;
    @XmlJavaTypeAdapter(value=PersistenceReferenceXmlAdapter.class)
    protected AnnotationMatrix annotations;
    protected List<HeatmapHeader> headers;
    private boolean gridEnabled = true;
    private int gridSize = 1;
    @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
    private Color gridColor;
    @XmlTransient
    private Set<String> highlightedLabels;
    PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HeatmapDim.this.propertyChange(evt);
        }
    };

    public HeatmapDim() {
        this.idType = IdTypeManager.getDefault().getDefaultIdType();
        this.headers = new ArrayList<HeatmapHeader>();
        this.gridColor = Color.WHITE;
        this.highlightedLabels = new HashSet<String>();
    }

    private void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String pname = evt.getPropertyName();
        if (src instanceof HeatmapHeader && ("size".equals(pname) || "visible".equals(pname))) {
            this.firePropertyChange(HEADER_SIZE_CHANGED);
        }
        this.firePropertyChange(evt);
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        IdType old = this.idType;
        this.idType = idType;
        this.firePropertyChange(IDTYPE_CHANGED, old, idType);
    }

    public List<HeatmapHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(HeatmapHeader header) {
        this.headers.add(header);
        header.addPropertyChangeListener(this.propertyListener);
        this.firePropertyChange(HEADERS_CHANGED);
    }

    public void removeHeader(int index) {
        if (index >= this.headers.size()) {
            return;
        }
        HeatmapHeader header = this.headers.get(index);
        header.removePropertyChangeListener(this.propertyListener);
        this.headers.remove(header);
        this.firePropertyChange(HEADERS_CHANGED);
    }

    public void upHeader(int index) {
        if (index == 0 || index >= this.headers.size()) {
            return;
        }
        HeatmapHeader header = this.headers.get(index);
        this.headers.set(index, this.headers.get(index - 1));
        this.headers.set(index - 1, header);
        this.firePropertyChange(HEADERS_CHANGED);
    }

    public void downHeader(int index) {
        if (index >= this.headers.size() - 1) {
            return;
        }
        HeatmapHeader header = this.headers.get(index);
        this.headers.set(index, this.headers.get(index + 1));
        this.headers.set(index + 1, header);
        this.firePropertyChange(HEADERS_CHANGED);
    }

    public int getHeaderSize() {
        int size = 0;
        for (HeatmapHeader h : this.headers) {
            size += h.getSize();
        }
        return size;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean enabled) {
        boolean old = this.gridEnabled;
        this.gridEnabled = enabled;
        this.firePropertyChange(GRID_PROPERTY_CHANGED, old, enabled);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        int old = this.gridSize;
        this.gridSize = gridSize;
        this.firePropertyChange(GRID_PROPERTY_CHANGED, old, gridSize);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        Color old = this.gridColor;
        this.gridColor = gridColor;
        this.firePropertyChange(GRID_PROPERTY_CHANGED, old, gridColor);
    }

    public AnnotationMatrix getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationMatrix annotations) {
        AnnotationMatrix old = this.annotations;
        this.annotations = annotations;
        this.firePropertyChange(ANNOTATIONS_CHANGED, old, annotations);
    }

    public boolean isHighlighted(String label) {
        return this.highlightedLabels.contains(label);
    }

    public void setHighlightedLabels(Set<String> highlightedLabels) {
        this.highlightedLabels = highlightedLabels;
        this.firePropertyChange(HIGHLIGHTING_CHANGED);
    }

    public void clearHighlightedLabels() {
        this.highlightedLabels.clear();
        this.firePropertyChange(HIGHLIGHTING_CHANGED);
    }
}

