/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.heatmap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.heatmap.xml.HeatmapMatrixViewXmlAdapter;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.model.Figure;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.ElementDecoratorFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Heatmap
extends Figure
implements Serializable {
    private static final long serialVersionUID = 325437934312047512L;
    public static final String CELL_DECORATOR_CHANGED = "cellDecorator";
    public static final String CELL_DECORATOR_SWITCHED = "cellDecoratorSwitched";
    public static final String MATRIX_VIEW_CHANGED = "matrixView";
    public static final String CELL_SIZE_CHANGED = "cellSize";
    public static final String ROW_DIMENSION_CHANGED = "rowDim";
    public static final String COLUMN_DIMENSION_CHANGED = "columnDim";
    @Deprecated
    public static final String ROW_LABELS_HEADER_CHANGED = "rowDecorator";
    @Deprecated
    public static final String COLUMN_LABELS_HEADER_CHANGED = "columnDecorator";
    @Deprecated
    public static final String GRID_PROPERTY_CHANGED = "gridProperty";
    @XmlJavaTypeAdapter(value=HeatmapMatrixViewXmlAdapter.class)
    private IMatrixView matrixView;
    private ElementDecorator activeDecorator;
    private ElementDecorator[] cellDecorators;
    private int cellWidth;
    private int cellHeight;
    private HeatmapDim rowDim;
    private HeatmapDim columnDim;
    @XmlTransient
    private boolean showBorders;
    PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Heatmap.this.firePropertyChange(evt);
        }
    };

    public Heatmap() {
        this(null, null, new HeatmapTextLabelsHeader(), new HeatmapTextLabelsHeader());
    }

    public Heatmap(IMatrixView matrixView) {
        this(matrixView, Heatmap.cellDecoratorFromMatrix(matrixView), new HeatmapTextLabelsHeader(), new HeatmapTextLabelsHeader());
    }

    public Heatmap(IMatrixView matrixView, ElementDecorator cellDecorator, HeatmapTextLabelsHeader rowsLabelsHeader, HeatmapTextLabelsHeader columnLabelsHeader) {
        this.matrixView = matrixView;
        this.matrixView.addPropertyChangeListener(this.propertyListener);
        this.activeDecorator = cellDecorator;
        this.activeDecorator.addPropertyChangeListener(this.propertyListener);
        this.cellWidth = 14;
        this.cellHeight = 14;
        this.showBorders = false;
        this.rowDim = new HeatmapDim();
        this.rowDim.addHeader(rowsLabelsHeader);
        this.rowDim.addPropertyChangeListener(this.propertyListener);
        this.columnDim = new HeatmapDim();
        this.columnDim.addHeader(columnLabelsHeader);
        this.columnDim.addPropertyChangeListener(this.propertyListener);
    }

    private static ElementDecorator cellDecoratorFromMatrix(IMatrixView matrixView) {
        Class<?> elementClass;
        ElementDecorator decorator = null;
        IElementAdapter adapter = matrixView.getCellAdapter();
        List<IElementAttribute> attributes = matrixView.getCellAttributes();
        int attrIndex = matrixView.getSelectedPropertyIndex();
        if (attrIndex >= 0 && attrIndex < attributes.size() && (Double.class.isInstance(elementClass = attributes.get(attrIndex).getValueClass()) || Double.TYPE.isInstance(elementClass))) {
            decorator = ElementDecoratorFactory.create("Linear two sided scale", adapter);
        }
        if (decorator == null) {
            decorator = ElementDecoratorFactory.create("Linear two sided scale", adapter);
        }
        return decorator;
    }

    public final IMatrixView getMatrixView() {
        return this.matrixView;
    }

    public final void setMatrixView(IMatrixView matrixView) {
        this.matrixView.removePropertyChangeListener(this.propertyListener);
        matrixView.addPropertyChangeListener(this.propertyListener);
        IMatrixView old = this.matrixView;
        this.matrixView = matrixView;
        this.firePropertyChange(MATRIX_VIEW_CHANGED, old, matrixView);
    }

    public final ElementDecorator getActiveCellDecorator() {
        int propIndex = this.getMatrixView().getSelectedPropertyIndex();
        return this.cellDecorators[propIndex];
    }

    public final void changeActiveCellDecorator(int newindex) {
        int oldindex = this.getMatrixView().getSelectedPropertyIndex();
        this.getMatrixView().setSelectedPropertyIndex(newindex);
        this.cellDecorators[oldindex].removePropertyChangeListener(this.propertyListener);
        this.cellDecorators[newindex].addPropertyChangeListener(this.propertyListener);
        this.firePropertyChange(CELL_DECORATOR_SWITCHED, this.cellDecorators[oldindex], this.cellDecorators[newindex]);
    }

    public void replaceActiveDecorator(ElementDecorator newDecorator) throws Exception {
        int propIndex = this.getMatrixView().getSelectedPropertyIndex();
        this.cellDecorators[propIndex].removePropertyChangeListener(this.propertyListener);
        newDecorator.addPropertyChangeListener(this.propertyListener);
        ElementDecorator old = this.cellDecorators[propIndex];
        if (!old.getAdapter().getElementClass().equals(newDecorator.getAdapter().getElementClass())) {
            throw new Exception("Substituting decorator not of same class");
        }
        this.cellDecorators[propIndex] = newDecorator;
        this.firePropertyChange(CELL_DECORATOR_CHANGED, old, newDecorator);
    }

    public final void setCellDecorators(ElementDecorator[] decorators) {
        int propIndex = this.getMatrixView().getSelectedPropertyIndex();
        ElementDecorator old = null;
        if (this.cellDecorators != null) {
            this.cellDecorators[propIndex].removePropertyChangeListener(this.propertyListener);
            old = this.cellDecorators[propIndex];
        }
        decorators[propIndex].addPropertyChangeListener(this.propertyListener);
        this.cellDecorators = decorators;
        this.firePropertyChange(CELL_DECORATOR_CHANGED, old, decorators[propIndex]);
    }

    public final ElementDecorator[] getCellDecorators() {
        return this.cellDecorators;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int cellWidth) {
        int old = this.cellWidth;
        this.cellWidth = cellWidth;
        this.firePropertyChange(CELL_SIZE_CHANGED, old, cellWidth);
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        int old = this.cellHeight;
        this.cellHeight = cellHeight;
        this.firePropertyChange(CELL_SIZE_CHANGED, old, cellHeight);
    }

    public HeatmapDim getRowDim() {
        return this.rowDim;
    }

    public void setRowDim(HeatmapDim rowDim) {
        this.rowDim.removePropertyChangeListener(this.propertyListener);
        rowDim.addPropertyChangeListener(this.propertyListener);
        HeatmapDim old = this.rowDim;
        this.rowDim = rowDim;
        this.firePropertyChange(ROW_DIMENSION_CHANGED, old, rowDim);
    }

    public HeatmapDim getColumnDim() {
        return this.columnDim;
    }

    public void setColumnDim(HeatmapDim columnDim) {
        this.columnDim.removePropertyChangeListener(this.propertyListener);
        columnDim.addPropertyChangeListener(this.propertyListener);
        HeatmapDim old = this.columnDim;
        this.columnDim = columnDim;
        this.firePropertyChange(COLUMN_DIMENSION_CHANGED, old, columnDim);
    }

    public boolean isShowBorders() {
        return this.showBorders;
    }

    public void setShowBorders(boolean showBorders) {
        this.showBorders = showBorders;
    }

    @Deprecated
    public String getColumnLabel(int index) {
        String label = this.matrixView.getColumnLabel(index);
        return label;
    }

    @Deprecated
    public String getRowLabel(int index) {
        String label = this.matrixView.getRowLabel(index);
        return label;
    }

    @Deprecated
    public String getColumnLinkUrl(int index) {
        return "";
    }

    @Deprecated
    public String getRowLinkUrl(int index) {
        return "";
    }
}

