/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.exporter;

import edu.upf.bg.fileutils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.gitools.datafilters.ValueTranslator;
import org.gitools.datafilters.ValueTranslatorFactory;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;

public class TextMatrixViewExporter {
    public static void exportMatrix(IMatrixView matrixView, int propIndex, File file) throws IOException {
        PrintWriter pw = new PrintWriter(IOUtils.openWriter(file));
        int rowCount = matrixView.getRowCount();
        int colCount = matrixView.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            pw.print("\t" + matrixView.getColumnLabel(c));
        }
        pw.println();
        IElementAttribute attr = matrixView.getContents().getCellAttributes().get(propIndex);
        ValueTranslator vt = ValueTranslatorFactory.createValueTranslator(attr.getValueClass());
        for (int r = 0; r < rowCount; ++r) {
            pw.print(matrixView.getRowLabel(r).toString());
            for (int c = 0; c < colCount; ++c) {
                Object value = matrixView.getCellValue(r, c, propIndex);
                String valueString = vt.valueToString(value);
                pw.print("\t" + valueString);
            }
            pw.println();
        }
        pw.close();
    }

    public static void exportTable(IMatrixView matrixView, int[] propIndices, File file) throws IOException {
        int i;
        PrintWriter pw = new PrintWriter(IOUtils.openWriter(file));
        List<IElementAttribute> attributes = matrixView.getCellAttributes();
        int rowCount = matrixView.getRowCount();
        int colCount = matrixView.getColumnCount();
        int propCount = propIndices.length;
        ValueTranslator[] vt = new ValueTranslator[propCount];
        pw.print("column\trow");
        for (i = 0; i < propIndices.length; ++i) {
            IElementAttribute attr = attributes.get(propIndices[i]);
            vt[i] = ValueTranslatorFactory.createValueTranslator(attr.getValueClass());
            pw.print("\t" + attr.getId());
        }
        pw.println();
        for (i = 0; i < rowCount * colCount; ++i) {
            int r = i / colCount;
            int c = i % colCount;
            if (matrixView.getCell(r, c) == null) continue;
            pw.print(matrixView.getColumnLabel(c));
            pw.print("\t" + matrixView.getRowLabel(r));
            for (int p = 0; p < propCount; ++p) {
                Object value = matrixView.getCellValue(r, c, propIndices[p]);
                String valueString = vt[p].valueToString(value);
                pw.print("\t" + valueString);
            }
            pw.println();
        }
        pw.close();
    }
}

