/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.exporter;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.gitools._DEPRECATED.resources.FileResource;

public class TemplateEngine {
    private VelocityEngine velocityEngine = new VelocityEngine();
    private String templateName;
    private Template template;
    private VelocityContext context;

    public TemplateEngine(Properties props) {
        this.velocityEngine.setProperty("resource.loader", (Object)"file, class");
        this.velocityEngine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.velocityEngine.setProperty("directive.foreach.counter.name", (Object)"forIndex");
        this.velocityEngine.setProperty("directive.foreach.counter.initial.value", (Object)"0");
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            this.velocityEngine.setProperty((String)prop.getKey(), prop.getValue());
        }
        this.context = new VelocityContext();
    }

    public TemplateEngine() {
        this(new Properties());
    }

    public void setFileLoaderPath(File file) {
        this.velocityEngine.setProperty("file.resource.loader.path", Arrays.asList(file.getAbsolutePath()));
    }

    public void init() {
        try {
            this.velocityEngine.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void loadTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (this.template == null || !this.templateName.equals(name)) {
            this.template = this.velocityEngine.getTemplate(name);
            this.templateName = name;
        }
    }

    public void setContext(Map<?, ?> context) {
        this.context = new VelocityContext(context);
    }

    public void render(Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException {
        this.template.merge((Context)this.context, writer);
    }

    public void render(File file) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException {
        Writer writer = FileResource.openWriter(file);
        this.render(writer);
        writer.close();
    }
}

