/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.exporter;

import edu.upf.bg.formatter.GenericFormatter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.gitools.exporter.AbstractHtmlExporter;
import org.gitools.exporter.TemplateEngine;
import org.gitools.heatmap.Heatmap;
import org.gitools.model.decorator.ElementDecoration;

public class HtmlHeatmapExporter
extends AbstractHtmlExporter {
    public void exportHeatmap(Heatmap figure) {
        File templatePath = this.getTemplatePath();
        if (templatePath == null) {
            throw new RuntimeException("Unable to locate templates path !");
        }
        try {
            this.copy(new File(templatePath, "media"), this.basePath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        TemplateEngine eng = new TemplateEngine();
        eng.setFileLoaderPath(templatePath);
        eng.init();
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("fmt", new GenericFormatter());
            context.put("figure", figure);
            context.put("matrix", figure.getMatrixView());
            context.put("cellDecoration", new ElementDecoration());
            eng.setContext(context);
            File file = new File(this.basePath, this.indexName);
            eng.loadTemplate("matrixfigure.vm");
            eng.render(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

