/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class AbstractHtmlExporter {
    protected File basePath = new File(System.getProperty("user.dir"));
    protected String indexName = "index.html";

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    protected File getTemplatePath() {
        File templatePath = null;
        try {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            File appPath = new File(url.toURI());
            appPath = appPath.getParentFile() != null ? appPath.getParentFile() : appPath;
            appPath = appPath.getParentFile() != null ? appPath.getParentFile() : appPath;
            templatePath = new File(appPath, "templates/default");
            if (!templatePath.exists() && !(templatePath = new File(appPath = appPath.getParentFile() != null ? appPath.getParentFile() : appPath, "templates/default")).exists()) {
                return null;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return templatePath;
    }

    protected void copy(File src, File dst) throws IOException {
        File[] list;
        for (File file : list = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        })) {
            File dstFile = new File(dst, file.getName());
            if (file.isFile()) {
                this.copyFile(file, dstFile);
                continue;
            }
            if (!file.isDirectory()) continue;
            dstFile.mkdir();
            this.copy(file, dstFile);
        }
    }

    private void copyFile(File src, File dst) throws IOException {
        FileChannel in = new FileInputStream(src).getChannel();
        FileChannel out = new FileOutputStream(dst).getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.write(buffer);
            buffer.clear();
        }
    }
}

