/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringException;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.GenericClusteringResults;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.ClusterUtils;
import org.gitools.clustering.method.value.MatrixViewWeka;
import weka.clusterers.SimpleKMeans;
import weka.core.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;

public class WekaKmeansMethod
extends AbstractClusteringValueMethod {
    private int iterations;
    private int numClusters;
    private int seed;
    private NormalizableDistance distanceFunction;

    public WekaKmeansMethod() {
        this.classIndex = -1;
    }

    @Override
    public ClusteringResults cluster(ClusteringData clusterData, IProgressMonitor monitor) throws ClusteringException {
        try {
            if (this.iterations < 2) {
                return null;
            }
            Instances structure = ClusterUtils.buildInstanceStructure(clusterData, this.transpose);
            List<String> labels = ClusterUtils.getLabels(clusterData, this.transpose);
            MatrixViewWeka clusterWekaData = new MatrixViewWeka(structure, clusterData, this.classIndex);
            if (this.preprocess) {
                ClusterUtils.dataReductionProcess(clusterWekaData, monitor);
            }
            SimpleKMeans clusterer = new SimpleKMeans();
            this.configure(clusterer);
            monitor.begin("Creating clustering model ...", 1);
            clusterer.buildClusterer((Instances)clusterWekaData);
            GenericClusteringResults results = null;
            if (!monitor.isCancelled()) {
                monitor.end();
                monitor.begin("Clustering instances ...", clusterWekaData.numInstances());
                Instance current = null;
                Integer maxLength = Integer.toString(clusterer.numberOfClusters()).length();
                HashMap<String, List<Integer>> clusterResults = new HashMap<String, List<Integer>>();
                for (int i = 0; i < clusterWekaData.numInstances() && !monitor.isCancelled(); ++i) {
                    current = clusterWekaData.get(i);
                    if (current != null) {
                        int cluster = clusterer.clusterInstance(current);
                        List<Integer> instancesCluster = clusterResults.get(ClusterUtils.valueToString(cluster, maxLength));
                        if (instancesCluster == null) {
                            instancesCluster = new ArrayList<Integer>();
                        }
                        instancesCluster.add(i);
                        clusterResults.put(ClusterUtils.valueToString(cluster, maxLength), instancesCluster);
                    }
                    monitor.worked(1);
                }
                results = new GenericClusteringResults(labels.toArray(new String[0]), clusterResults);
            }
            return results;
        }
        catch (Throwable ex) {
            if (ex instanceof OutOfMemoryError) {
                throw new ClusteringException("Insufficient memory for HCL clustering. Increase memory size or try another clustering method", ex);
            }
            throw new ClusteringException(ex);
        }
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seedKmeans) {
        this.seed = seedKmeans;
    }

    public NormalizableDistance getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(NormalizableDistance distance) {
        this.distanceFunction = distance;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        this.numClusters = numClusters;
    }

    private void configure(SimpleKMeans clusterer) throws Exception {
        clusterer.setMaxIterations(this.iterations);
        clusterer.setNumClusters(this.numClusters);
        clusterer.setSeed(this.seed);
        clusterer.setDistanceFunction((DistanceFunction)this.distanceFunction);
    }
}

