/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.List;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringException;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.HierarchicalClusteringResults;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.ClusterUtils;
import org.gitools.clustering.method.value.MatrixViewWeka;
import org.gitools.clustering.method.value.WekaHierarchicalClusterer;
import org.gitools.newick.NewickParser;
import org.gitools.newick.NewickTree;
import weka.core.DistanceFunction;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.SelectedTag;

public class WekaHCLMethod
extends AbstractClusteringValueMethod {
    private SelectedTag linkType;
    private boolean distanceIsBranchLength;
    private int numClusters;
    private boolean printNewick;
    private NormalizableDistance distanceFunction;

    public WekaHCLMethod() {
        this.classIndex = -1;
    }

    @Override
    public ClusteringResults cluster(ClusteringData clusterData, IProgressMonitor monitor) throws ClusteringException {
        try {
            Instances structure = ClusterUtils.buildInstanceStructure(clusterData, this.transpose);
            MatrixViewWeka clusterWekaData = new MatrixViewWeka(structure, clusterData, this.classIndex);
            List<String> labels = ClusterUtils.getLabels(clusterData, this.transpose);
            if (this.preprocess) {
                ClusterUtils.dataReductionProcess(clusterWekaData, monitor);
            }
            WekaHierarchicalClusterer clusterer = new WekaHierarchicalClusterer();
            this.configure(clusterer);
            clusterer.buildClusterer(clusterWekaData);
            HierarchicalClusteringResults results = null;
            if (!monitor.isCancelled()) {
                monitor.end();
                monitor.begin("Clustering instances ...", clusterWekaData.getMatrixView().getSize());
                NewickParser newickParser = new NewickParser(clusterer.graph() + ";");
                NewickTree tree = newickParser.parse();
                results = new HierarchicalClusteringResults(labels.toArray(new String[labels.size()]), tree, 0);
            }
            return results;
        }
        catch (Throwable ex) {
            if (ex instanceof OutOfMemoryError) {
                throw new ClusteringException("Insufficient memory for HCL clustering. Increase memory size or try another clustering method", ex);
            }
            throw new ClusteringException(ex);
        }
    }

    public NormalizableDistance getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(NormalizableDistance distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public boolean isDistanceIsBranchLength() {
        return this.distanceIsBranchLength;
    }

    public void setDistanceIsBranchLength(boolean distanceIsBranchLength) {
        this.distanceIsBranchLength = distanceIsBranchLength;
    }

    public SelectedTag getLinkType() {
        return this.linkType;
    }

    public void setLinkType(SelectedTag linkType) {
        this.linkType = linkType;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        this.numClusters = numClusters;
    }

    public boolean isPrintNewick() {
        return this.printNewick;
    }

    public void setPrintNewick(boolean printNewick) {
        this.printNewick = printNewick;
    }

    private void configure(WekaHierarchicalClusterer clusterer) {
        clusterer.setDistanceFunction((DistanceFunction)this.distanceFunction);
        clusterer.setPrintNewick(this.printNewick);
        clusterer.setNumClusters(this.numClusters);
        clusterer.setLinkType(this.linkType);
        clusterer.setDistanceIsBranchLength(this.distanceIsBranchLength);
    }
}

