/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringException;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.GenericClusteringResults;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.ClusterUtils;
import org.gitools.clustering.method.value.MatrixViewWeka;
import weka.clusterers.Cobweb;
import weka.core.Instance;
import weka.core.Instances;

public class WekaCobWebMethod
extends AbstractClusteringValueMethod {
    private float acuity;
    private float cutoff;
    private int seed;

    public WekaCobWebMethod() {
        this.classIndex = 0;
    }

    @Override
    public ClusteringResults cluster(ClusteringData clusterData, IProgressMonitor monitor) throws ClusteringException {
        try {
            Instances structure = ClusterUtils.buildInstanceStructure(clusterData, this.transpose);
            List<String> labels = ClusterUtils.getLabels(clusterData, this.transpose);
            MatrixViewWeka clusterWekaData = new MatrixViewWeka(structure, clusterData, this.classIndex);
            if (this.preprocess) {
                ClusterUtils.dataReductionProcess(clusterWekaData, monitor);
            }
            Cobweb clusterer = new Cobweb();
            this.configure(clusterer);
            clusterer.buildClusterer(clusterWekaData.getStructure());
            monitor.begin("Creating clustering model ...", clusterWekaData.getMatrixView().getSize() + 1);
            GenericClusteringResults results = null;
            Instance current = null;
            for (int j = 0; j < clusterWekaData.getMatrixView().getSize() && !monitor.isCancelled(); ++j) {
                current = clusterWekaData.get(j);
                if (current != null) {
                    clusterer.updateClusterer(current);
                }
                monitor.worked(1);
            }
            if (!monitor.isCancelled()) {
                clusterer.updateFinished();
                monitor.end();
                monitor.begin("Clustering instances ...", clusterWekaData.getMatrixView().getSize());
                Integer maxLength = Integer.toString(clusterer.numberOfClusters()).length();
                HashMap<String, List<Integer>> clusterResults = new HashMap<String, List<Integer>>();
                for (int i = 0; i < clusterWekaData.getMatrixView().getSize() && !monitor.isCancelled(); ++i) {
                    current = clusterWekaData.get(i);
                    if (current != null) {
                        Integer cluster = clusterer.clusterInstance(current);
                        List<Integer> instancesCluster = clusterResults.get(ClusterUtils.valueToString(cluster, maxLength));
                        if (instancesCluster == null) {
                            instancesCluster = new ArrayList<Integer>();
                        }
                        instancesCluster.add(i);
                        clusterResults.put(ClusterUtils.valueToString(cluster, maxLength), instancesCluster);
                    }
                    monitor.worked(1);
                }
                results = new GenericClusteringResults(labels.toArray(new String[0]), clusterResults);
            }
            return results;
        }
        catch (Throwable ex) {
            if (ex instanceof OutOfMemoryError) {
                throw new ClusteringException("Insufficient memory for HCL clustering. Increase memory size or try another clustering method", ex);
            }
            throw new ClusteringException(ex);
        }
    }

    public float getAcuity() {
        return this.acuity;
    }

    public void setAcuity(float acuity) {
        this.acuity = acuity;
    }

    public float getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(float cutoff) {
        this.cutoff = cutoff;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    private void configure(Cobweb clusterer) {
        clusterer.setAcuity((double)this.acuity);
        clusterer.setCutoff((double)this.cutoff);
        clusterer.setSeed(this.seed);
    }
}

