/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import java.io.IOException;
import org.gitools.clustering.ClusteringData;
import org.gitools.matrix.MatrixUtils;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class MatrixViewWeka
extends Instances {
    private ClusteringData matrixView;
    private Instances structure;
    private int[] indexes;
    private int dimMatrix;
    private int initClassIndex;

    public MatrixViewWeka(Instances ds, ClusteringData matrix, int classIndex) {
        super(ds);
        this.initClassIndex = this.m_ClassIndex = classIndex;
        this.structure = new Instances("matrixToCluster", this.m_Attributes, 0);
        this.indexes = null;
        this.matrixView = matrix;
    }

    public FastVector addAttributes(int numAttributes) {
        FastVector attr = new FastVector();
        for (int rows = 0; rows < numAttributes; ++rows) {
            attr.addElement((Object)new Attribute("a" + rows));
        }
        return attr;
    }

    public Instances getStructure() throws IOException {
        return this.structure;
    }

    public void setDataSet(Instances mergeInstances) {
    }

    public Instances getDataSet() throws IOException {
        Instance current = null;
        Instances dataSet = new Instances("matrixToCluster", this.m_Attributes, 0);
        try {
            for (int i = 0; i < this.matrixView.getSize(); ++i) {
                current = this.get(i);
                dataSet.add(current);
            }
        }
        catch (Exception ex) {
            throw new IOException("Error retrieving Weka dataset");
        }
        return dataSet;
    }

    public Instance get(int index) throws Exception {
        if (index > this.matrixView.getSize() - 1) {
            return null;
        }
        double[] values = null;
        MatrixUtils.DoubleCast valueCast = MatrixUtils.createDoubleCast(this.matrixView.getInstance(index).getValueClass(0));
        if (this.indexes == null) {
            values = new double[this.matrixView.getInstance(index).getNumAttributes()];
            for (int row = 0; row < this.matrixView.getInstance(index).getNumAttributes(); ++row) {
                try {
                    values[row] = valueCast.getDoubleValue(this.matrixView.getInstance(index).getValue(row));
                    continue;
                }
                catch (Exception e) {
                    values[row] = Double.NaN;
                }
            }
        } else {
            values = new double[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                try {
                    int row = this.indexes[i];
                    values[i] = valueCast.getDoubleValue(this.matrixView.getInstance(index).getValue(row));
                    continue;
                }
                catch (Exception e) {
                    values[i] = Double.NaN;
                }
            }
        }
        Instance current = new Instance(1.0, values);
        Instances dataset = new Instances("matrixToCluster", this.m_Attributes, 0);
        dataset.setClassIndex(this.m_ClassIndex);
        current.setDataset(dataset);
        dataset.add(current);
        return current;
    }

    void setFilteredAttributes(int[] selectedAttributes) {
        this.indexes = selectedAttributes;
        this.m_Attributes = this.addAttributes(selectedAttributes.length);
        this.structure = new Instances("matrixToCluster", this.m_Attributes, 0);
        this.m_ClassIndex = this.initClassIndex;
    }

    void resetFilteredAttributes() {
        this.indexes = null;
        this.m_Attributes = this.addAttributes(this.matrixView.getSize());
        this.structure = new Instances("matrixToCluster", this.m_Attributes, 0);
    }

    public int numInstances() {
        return this.matrixView.getSize();
    }

    public Instance instance(int i) {
        try {
            return this.get(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int numAttributes() {
        if (this.matrixView.getInstance(0) == null) {
            return 0;
        }
        if (this.indexes == null) {
            return this.matrixView.getInstance(0).getNumAttributes();
        }
        return this.indexes.length;
    }

    public Attribute attribute(Integer index) {
        return (Attribute)this.m_Attributes.elements(index.intValue());
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public ClusteringData getMatrixView() {
        return this.matrixView;
    }

    public void setClassIndex(int index) {
        this.m_ClassIndex = index;
    }
}

