/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringDataInstance;
import org.gitools.matrix.model.IMatrix;

public class MatrixRowClusteringData
implements ClusteringData {
    private IMatrix matrix;
    private int matrixAttribute;
    private Class<?> attributeClass;

    public MatrixRowClusteringData(IMatrix matrix, int matrixAttribute) {
        this.matrix = matrix;
        this.matrixAttribute = matrixAttribute;
        this.attributeClass = matrix.getCellAttributes().get(matrixAttribute).getValueClass();
    }

    @Override
    public int getSize() {
        return this.matrix.getRowCount();
    }

    @Override
    public String getLabel(int index) {
        return this.matrix.getRowLabel(index);
    }

    @Override
    public ClusteringDataInstance getInstance(int index) {
        return new Instance(index);
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
    }

    public IMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(IMatrix matrix) {
        this.matrix = matrix;
    }

    public int getNumAttributes() {
        return this.matrix.getColumnCount();
    }

    public class Instance
    implements ClusteringDataInstance {
        protected int index;

        public Instance(int index) {
            this.index = index;
        }

        @Override
        public int getNumAttributes() {
            return MatrixRowClusteringData.this.matrix.getColumnCount();
        }

        @Override
        public String getAttributeName(int attribute) {
            return MatrixRowClusteringData.this.matrix.getColumnLabel(attribute);
        }

        @Override
        public Class<?> getValueClass(int attribute) {
            return MatrixRowClusteringData.this.attributeClass;
        }

        @Override
        public Object getValue(int attribute) {
            return MatrixRowClusteringData.this.matrix.getCellValue(this.index, attribute, MatrixRowClusteringData.this.matrixAttribute);
        }

        @Override
        public <T> T getTypedValue(int attribute, Class<T> valueClass) {
            if (!valueClass.equals(this.getValueClass(attribute))) {
                throw new RuntimeException("Unsupported type: " + valueClass.getCanonicalName());
            }
            return (T)MatrixRowClusteringData.this.matrix.getCellValue(this.index, attribute, MatrixRowClusteringData.this.matrixAttribute);
        }
    }
}

