/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringDataInstance;
import org.gitools.matrix.model.IMatrix;

public class MatrixColumnClusteringData
implements ClusteringData {
    private IMatrix matrix;
    private int matrixAttribute;
    private Class<?> attributeClass;

    public MatrixColumnClusteringData(IMatrix matrix, int matrixAttribute) {
        this.matrix = matrix;
        this.matrixAttribute = matrixAttribute;
        this.attributeClass = matrix.getCellAttributes().get(matrixAttribute).getValueClass();
    }

    @Override
    public int getSize() {
        return this.matrix.getColumnCount();
    }

    @Override
    public String getLabel(int index) {
        return this.matrix.getColumnLabel(index);
    }

    @Override
    public ClusteringDataInstance getInstance(int index) {
        return new Instance(index);
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
    }

    public IMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(IMatrix matrix) {
        this.matrix = matrix;
    }

    public int getNumAttributes() {
        return this.matrix.getRowCount();
    }

    public class Instance
    implements ClusteringDataInstance {
        private int index;

        public Instance(int index) {
            this.index = index;
        }

        @Override
        public int getNumAttributes() {
            return MatrixColumnClusteringData.this.matrix.getRowCount();
        }

        @Override
        public String getAttributeName(int attribute) {
            return MatrixColumnClusteringData.this.matrix.getRowLabel(attribute);
        }

        @Override
        public Class<?> getValueClass(int attribute) {
            return MatrixColumnClusteringData.this.attributeClass;
        }

        @Override
        public Object getValue(int attribute) {
            return MatrixColumnClusteringData.this.matrix.getCellValue(attribute, this.index, MatrixColumnClusteringData.this.matrixAttribute);
        }

        @Override
        public <T> T getTypedValue(int attribute, Class<T> valueClass) {
            if (!valueClass.equals(this.getValueClass(attribute))) {
                throw new RuntimeException("Unsupported type: " + valueClass.getCanonicalName());
            }
            return (T)MatrixColumnClusteringData.this.matrix.getCellValue(attribute, this.index, MatrixColumnClusteringData.this.matrixAttribute);
        }
    }
}

