/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.List;
import java.util.Properties;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.ClusteringMethodFactory;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.ClusterUtils;
import org.gitools.clustering.method.value.MatrixColumnClusteringData;
import org.gitools.clustering.method.value.MatrixRowClusteringData;
import org.gitools.clustering.method.value.WekaCobWebMethod;
import org.gitools.clustering.method.value.WekaHCLMethod;
import org.gitools.clustering.method.value.WekaHierarchicalClusterer;
import org.gitools.clustering.method.value.WekaKmeansMethod;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.model.IMatrixView;
import weka.core.EuclideanDistance;
import weka.core.ManhattanDistance;
import weka.core.NormalizableDistance;
import weka.core.SelectedTag;

public class Clusterer {
    public static ClusteringResults matrixClustering(IMatrixView matrixView, Properties clusterParameters, IProgressMonitor monitor, boolean sortMatrix) throws Exception {
        int dimMatrix;
        ClusteringMethodDescriptor descriptor = null;
        List<ClusteringMethodDescriptor> descriptors = ClusteringMethodFactory.getDefault().getDescriptors();
        for (ClusteringMethodDescriptor desc : descriptors) {
            if (!desc.getDescription().contains(clusterParameters.getProperty("method"))) continue;
            descriptor = desc;
        }
        ClusteringData data = null;
        AbstractClusteringValueMethod method = null;
        if (descriptor.getMethodClass().equals(WekaCobWebMethod.class)) {
            method = (WekaCobWebMethod)ClusteringMethodFactory.getDefault().create(descriptor);
            dimMatrix = new Integer(clusterParameters.getProperty("index"));
            data = Boolean.valueOf(clusterParameters.getProperty("transpose")) != false ? new MatrixRowClusteringData(matrixView, dimMatrix) : new MatrixColumnClusteringData(matrixView, dimMatrix);
            ((WekaCobWebMethod)method).setTranspose(Boolean.valueOf(clusterParameters.getProperty("transpose")));
            ((WekaCobWebMethod)method).setAcuity(Float.valueOf(clusterParameters.getProperty("acuity")).floatValue());
            ((WekaCobWebMethod)method).setCutoff(Float.valueOf(clusterParameters.getProperty("cutoff")).floatValue());
            ((WekaCobWebMethod)method).setSeed(Integer.valueOf(clusterParameters.getProperty("seedCobweb")));
            ((WekaCobWebMethod)method).setPreprocess(Boolean.valueOf(clusterParameters.getProperty("preprocessing")));
        }
        if (descriptor.getMethodClass().equals(WekaKmeansMethod.class)) {
            method = (WekaKmeansMethod)ClusteringMethodFactory.getDefault().create(descriptor);
            dimMatrix = new Integer(clusterParameters.getProperty("index"));
            data = Boolean.valueOf(clusterParameters.getProperty("transpose")) != false ? new MatrixRowClusteringData(matrixView, dimMatrix) : new MatrixColumnClusteringData(matrixView, dimMatrix);
            ((WekaKmeansMethod)method).setTranspose(Boolean.valueOf(clusterParameters.getProperty("transpose")));
            ((WekaKmeansMethod)method).setPreprocess(Boolean.valueOf(clusterParameters.getProperty("preprocessing")));
            ((WekaKmeansMethod)method).setIterations(Integer.valueOf(clusterParameters.getProperty("iterations", "500")));
            ((WekaKmeansMethod)method).setNumClusters(Integer.valueOf(clusterParameters.getProperty("k", "2")));
            ((WekaKmeansMethod)method).setSeed(Integer.valueOf(clusterParameters.getProperty("seedKmeans", "10")));
            if (clusterParameters.getProperty("distance", "euclidean").toLowerCase().equals("euclidean")) {
                ((WekaKmeansMethod)method).setDistanceFunction((NormalizableDistance)new EuclideanDistance());
            } else {
                ((WekaKmeansMethod)method).setDistanceFunction((NormalizableDistance)new ManhattanDistance());
            }
        }
        if (descriptor.getMethodClass().equals(WekaHCLMethod.class)) {
            method = (WekaHCLMethod)ClusteringMethodFactory.getDefault().create(descriptor);
            dimMatrix = new Integer(clusterParameters.getProperty("index"));
            data = Boolean.valueOf(clusterParameters.getProperty("transpose")) != false ? new MatrixRowClusteringData(matrixView, dimMatrix) : new MatrixColumnClusteringData(matrixView, dimMatrix);
            ((WekaHCLMethod)method).setTranspose(Boolean.valueOf(clusterParameters.getProperty("transpose")));
            ((WekaHCLMethod)method).setPreprocess(Boolean.valueOf(clusterParameters.getProperty("preprocessing")));
            ((WekaHCLMethod)method).setLinkType(new SelectedTag(clusterParameters.getProperty("link").toUpperCase(), WekaHierarchicalClusterer.TAGS_LINK_TYPE));
            ((WekaHCLMethod)method).setDistanceIsBranchLength(false);
            ((WekaHCLMethod)method).setNumClusters(1);
            ((WekaHCLMethod)method).setPrintNewick(true);
            if (clusterParameters.getProperty("distance").equalsIgnoreCase("euclidean")) {
                ((WekaHCLMethod)method).setDistanceFunction((NormalizableDistance)new EuclideanDistance());
            } else {
                ((WekaHCLMethod)method).setDistanceFunction((NormalizableDistance)new ManhattanDistance());
            }
        }
        ClusteringResults results = method.cluster(data, monitor);
        monitor.end();
        if (!monitor.isCancelled() && sortMatrix) {
            if (Boolean.valueOf(clusterParameters.getProperty("transpose")).booleanValue()) {
                TransposedMatrixView transposedMatrix = new TransposedMatrixView(matrixView);
                ClusterUtils.updateVisibility(transposedMatrix, results.getDataIndicesByClusterTitle());
            } else {
                ClusterUtils.updateVisibility(matrixView, results.getDataIndicesByClusterTitle());
            }
        }
        return results;
    }
}

