/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.value;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.method.value.MatrixColumnClusteringData;
import org.gitools.clustering.method.value.MatrixRowClusteringData;
import org.gitools.clustering.method.value.MatrixViewWeka;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.newick.NewickNode;
import org.gitools.newick.NewickParserException;
import org.gitools.newick.NewickTree;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;

public class ClusterUtils {
    private static final Integer MAX_ATTR = 200;
    private static final Integer MIN_ATTR = 10;

    public static void dataReductionProcess(MatrixViewWeka data, IProgressMonitor monitor) throws Exception, IOException {
        if (data.numAttributes() > MAX_ATTR || data.numAttributes() < MIN_ATTR) {
            return;
        }
        monitor.begin("Preprocessing data for clustering  ...", 1);
        CfsSubsetEval eval = new CfsSubsetEval();
        eval.setLocallyPredictive(true);
        GreedyStepwise search = new GreedyStepwise();
        search.setSearchBackwards(false);
        search.setGenerateRanking(false);
        AttributeSelection attSelection = new AttributeSelection();
        attSelection.setEvaluator((ASEvaluation)eval);
        attSelection.setSearch((ASSearch)search);
        attSelection.SelectAttributes((Instances)data);
        data.setFilteredAttributes(attSelection.selectedAttributes());
        monitor.end();
    }

    public static FastVector addAttributes(Integer numAttributes) {
        FastVector attr = new FastVector();
        for (int rows = 0; rows < numAttributes; ++rows) {
            attr.addElement((Object)new Attribute("a" + rows));
        }
        return attr;
    }

    public static void updateVisibility(IMatrixView matrixView, Map<String, int[]> clusterResults) {
        int[] visibleData = matrixView.getVisibleColumns();
        int[] sortedVisibleData = new int[matrixView.getVisibleColumns().length];
        int index = 0;
        Object[] clustersSorted = clusterResults.keySet().toArray(new String[clusterResults.keySet().size()]);
        Arrays.sort(clustersSorted);
        for (Object i : clustersSorted) {
            int[] arr$ = clusterResults.get(i);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer val = arr$[i$];
                sortedVisibleData[index++] = visibleData[val];
            }
        }
        matrixView.setVisibleColumns(sortedVisibleData);
    }

    @Deprecated
    public static Instances buildInstanceStructure(ClusteringData clusterData, boolean transposed) {
        FastVector attr = null;
        attr = transposed ? ClusterUtils.addAttributes(((MatrixRowClusteringData)clusterData).getNumAttributes()) : ClusterUtils.addAttributes(((MatrixColumnClusteringData)clusterData).getNumAttributes());
        return new Instances("matrixToCluster", attr, 0);
    }

    @Deprecated
    public static List<String> getLabels(ClusteringData clusterData, boolean transpose) {
        ArrayList<String> labels = new ArrayList<String>();
        if (transpose) {
            for (int i = 0; i < ((MatrixRowClusteringData)clusterData).getSize(); ++i) {
                labels.add(((MatrixRowClusteringData)clusterData).getLabel(i));
            }
        } else {
            for (int i = 0; i < ((MatrixColumnClusteringData)clusterData).getSize(); ++i) {
                labels.add(((MatrixColumnClusteringData)clusterData).getLabel(i));
            }
        }
        return labels;
    }

    @Deprecated
    public static String valueToString(Integer value, Integer maxLength) {
        int numLenght;
        String num = value.toString();
        for (int i = numLenght = num.length(); i < maxLength; ++i) {
            num = "0" + num;
        }
        return num;
    }

    public static List<Integer> getTreeLeaves(NewickTree tree) throws NumberFormatException, IOException, NewickParserException {
        ArrayList<Integer> instancesCluster = new ArrayList<Integer>();
        List<NewickNode> leaves = tree.getRoot().getLeaves();
        for (NewickNode node : leaves) {
            instancesCluster.add(new Integer(node.getName()));
        }
        return instancesCluster;
    }
}

