/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.annotations;

import edu.upf.bg.textpatt.TextPattern;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringDataInstance;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.AnnotationResolver;
import org.gitools.matrix.model.IMatrix;

public class AnnPatRowClusteringData
implements ClusteringData {
    private IMatrix matrix;
    private AnnotationMatrix am;
    private TextPattern pat;

    public AnnPatRowClusteringData(IMatrix matrix, AnnotationMatrix am, String pattern) {
        this.matrix = matrix;
        this.am = am;
        this.pat = new TextPattern(pattern);
    }

    @Override
    public int getSize() {
        return this.matrix.getRowCount();
    }

    @Override
    public String getLabel(int index) {
        return this.matrix.getRowLabel(index);
    }

    @Override
    public ClusteringDataInstance getInstance(int index) {
        return new Instance(new AnnotationResolver(this.am, this.matrix.getRowLabel(index), "N/A"));
    }

    public class Instance
    implements ClusteringDataInstance {
        private TextPattern.VariableValueResolver resolver;

        public Instance(TextPattern.VariableValueResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public int getNumAttributes() {
            return 1;
        }

        @Override
        public String getAttributeName(int attribute) {
            return "value";
        }

        @Override
        public Class<?> getValueClass(int attribute) {
            return String.class;
        }

        @Override
        public Object getValue(int attribute) {
            return AnnPatRowClusteringData.this.pat.generate(this.resolver);
        }

        @Override
        public <T> T getTypedValue(int attribute, Class<T> valueClass) {
            if (!String.class.equals(valueClass)) {
                throw new RuntimeException("Unsupported value class: " + valueClass.getName());
            }
            return (T)this.getValue(attribute);
        }
    }
}

