/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering.method.annotations;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gitools.clustering.ClusteringData;
import org.gitools.clustering.ClusteringMethod;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.GenericClusteringResults;

public class AnnPatClusteringMethod
implements ClusteringMethod {
    private String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public ClusteringResults cluster(ClusteringData data, IProgressMonitor monitor) {
        monitor.begin("Clustering by annotations", data.getSize() + 1);
        String[] dataLabels = new String[data.getSize()];
        HashMap<String, List<Integer>> clusters = new HashMap<String, List<Integer>>();
        for (int i = 0; i < data.getSize() && !monitor.isCancelled(); ++i) {
            String label;
            dataLabels[i] = label = data.getLabel(i);
            String clusterName = data.getInstance(i).getTypedValue(0, String.class);
            ArrayList<Integer> indices = (ArrayList<Integer>)clusters.get(clusterName);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                clusters.put(clusterName, indices);
            }
            indices.add(i);
            monitor.worked(1);
        }
        if (monitor.isCancelled()) {
            return null;
        }
        monitor.end();
        return new GenericClusteringResults(dataLabels, clusters);
    }
}

