/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gitools.clustering.GenericClusteringResults;
import org.gitools.newick.NewickNode;
import org.gitools.newick.NewickTree;

public class HierarchicalClusteringResults
extends GenericClusteringResults {
    private NewickTree tree;
    private int level;

    public HierarchicalClusteringResults(String[] labels, NewickTree tree, int level) {
        super(labels, new HashMap<String, List<Integer>>());
        this.tree = tree;
        this.level = level;
        this.updateClusters();
    }

    public NewickTree getTree() {
        return this.tree;
    }

    public void setNewickTree(NewickTree tree) {
        this.tree = tree;
        this.level = 0;
        this.updateClusters();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.updateClusters();
    }

    private void updateClusters() {
        NewickNode root = this.tree.getRoot();
        List<NewickNode> clusterLeaves = root.getLeaves(this.level);
        StringBuilder sb = new StringBuilder();
        int len = (int)(Math.floor(Math.log10(clusterLeaves.size())) + 1.0);
        for (int i = 0; i < len; ++i) {
            sb.append('0');
        }
        String fmtPat = sb.toString();
        DecimalFormat fmt = new DecimalFormat(fmtPat);
        int index = 0;
        HashMap<String, List<Integer>> clusters = new HashMap<String, List<Integer>>();
        for (NewickNode cluster : clusterLeaves) {
            List<NewickNode> nodes = cluster.getLeaves();
            ArrayList<Integer> indices = new ArrayList<Integer>(nodes.size());
            for (NewickNode node : nodes) {
                indices.add(Integer.parseInt(node.getName()));
            }
            String name = fmt.format(index++);
            clusters.put(name, indices);
        }
        this.init(this.getDataLabels(), clusters);
    }
}

