/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gitools.clustering.ClusteringResults;

public class GenericClusteringResults
implements ClusteringResults {
    private String[] clusterTitles;
    private String[] dataLabels;
    private int[][] clusterDataIndices;
    private int[] dataClusterIndex;
    private Map<String, Integer> clusterTitlesIndex;
    private Map<String, Integer> dataLabelsIndex;

    public GenericClusteringResults(String[] dataLabels, Map<String, List<Integer>> clusters) {
        this.init(dataLabels, clusters);
    }

    protected final void init(String[] dataLabels, Map<String, List<Integer>> clusters) {
        this.dataClusterIndex = null;
        this.clusterTitlesIndex = null;
        this.dataLabelsIndex = null;
        this.dataLabels = dataLabels;
        int numClusters = clusters.size();
        this.clusterDataIndices = new int[numClusters][];
        this.clusterTitles = clusters.keySet().toArray(new String[numClusters]);
        Arrays.sort(this.clusterTitles);
        for (int ci = 0; ci < numClusters; ++ci) {
            List<Integer> indices = clusters.get(this.clusterTitles[ci]);
            int[] indicesArray = new int[indices.size()];
            for (int i = 0; i < indicesArray.length; ++i) {
                indicesArray[i] = indices.get(i);
            }
            this.clusterDataIndices[ci] = indicesArray;
        }
    }

    private void createClusterDataIndices() {
        if (this.dataClusterIndex == null) {
            throw new RuntimeException("Data cluster indices required");
        }
        int numClusters = this.clusterTitles.length;
        int[] len = new int[numClusters];
        Arrays.fill(len, 0);
        int[] arr$ = this.dataClusterIndex;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int ci;
            int n = ci = arr$[i$];
            len[n] = len[n] + 1;
        }
        this.clusterDataIndices = new int[numClusters][];
        for (int ci = 0; ci < numClusters; ++ci) {
            this.clusterDataIndices[ci] = new int[len[ci]];
        }
        Arrays.fill(len, 0);
        int i = 0;
        while (i < this.dataClusterIndex.length) {
            int ci = this.dataClusterIndex[i];
            int[] dataIndices = this.clusterDataIndices[ci];
            int n = ci;
            int n2 = len[n];
            len[n] = n2 + 1;
            dataIndices[n2] = i++;
        }
    }

    private void createDataClusterIndices() {
        if (this.clusterDataIndices == null) {
            throw new RuntimeException("Cluster data indices required");
        }
        this.dataClusterIndex = new int[this.dataLabels.length];
        for (int ci = 0; ci < this.clusterDataIndices.length; ++ci) {
            int[] dataIndices = this.clusterDataIndices[ci];
            if (dataIndices == null) {
                throw new RuntimeException("Cluster data indices required: " + ci);
            }
            for (int i = 0; i < dataIndices.length; ++i) {
                this.dataClusterIndex[dataIndices[i]] = ci;
            }
        }
    }

    @Override
    public int getNumClusters() {
        return this.clusterTitles.length;
    }

    @Override
    public String[] getClusterTitles() {
        return this.clusterTitles;
    }

    @Override
    public int getClusterTitleIndex(String clusterTitle) {
        Integer index;
        if (this.clusterTitlesIndex == null) {
            this.clusterTitlesIndex = new HashMap<String, Integer>();
            for (int i = 0; i < this.clusterTitles.length; ++i) {
                this.clusterTitlesIndex.put(this.clusterTitles[i], i);
            }
        }
        return (index = this.clusterTitlesIndex.get(clusterTitle)) != null ? index : -1;
    }

    @Override
    public int getNumDataLabels() {
        return this.dataLabels.length;
    }

    @Override
    public String[] getDataLabels() {
        return this.dataLabels;
    }

    @Override
    public int getDataLabelIndex(String dataLabel) {
        Integer index;
        if (this.dataLabelsIndex == null) {
            this.dataLabelsIndex = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataLabels.length; ++i) {
                this.dataLabelsIndex.put(this.dataLabels[i], i);
            }
        }
        return (index = this.dataLabelsIndex.get(dataLabel)) != null ? index : -1;
    }

    @Override
    public int[] getDataIndices(int clusterIndex) {
        if (this.clusterDataIndices == null) {
            this.createClusterDataIndices();
        }
        return this.clusterDataIndices[clusterIndex];
    }

    @Override
    public int[] getDataIndices(String clusterTitle) {
        return this.getDataIndices(this.getClusterIndex(clusterTitle));
    }

    @Override
    public String[] getDataLabels(int clusterIndex) {
        int[] indices = this.getDataIndices(clusterIndex);
        String[] labels = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            labels[i] = this.dataLabels[indices[i]];
        }
        return labels;
    }

    @Override
    public String[] getDataLabels(String clusterTitle) {
        return this.getDataLabels(this.getClusterIndex(clusterTitle));
    }

    @Override
    public int getClusterIndex(int dataIndex) {
        if (this.dataClusterIndex == null) {
            this.createDataClusterIndices();
        }
        return this.dataClusterIndex[dataIndex];
    }

    @Override
    public int getClusterIndex(String dataLabel) {
        return this.getClusterIndex(this.getDataLabelIndex(dataLabel));
    }

    @Override
    public Map<String, int[]> getDataIndicesByClusterTitle() {
        if (this.clusterDataIndices == null) {
            this.createClusterDataIndices();
        }
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        for (int ci = 0; ci < this.clusterDataIndices.length; ++ci) {
            map.put(this.clusterTitles[ci], this.clusterDataIndices[ci]);
        }
        return map;
    }

    @Override
    public Map<String, Integer> getClusterIndexByDataLabel() {
        if (this.dataClusterIndex == null) {
            this.createDataClusterIndices();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.dataClusterIndex.length; ++i) {
            map.put(this.dataLabels[i], this.dataClusterIndex[i]);
        }
        return map;
    }
}

