/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.clustering;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gitools.clustering.ClusteringMethod;
import org.gitools.clustering.ClusteringMethodDescriptor;
import org.gitools.clustering.method.annotations.AnnPatClusteringMethod;
import org.gitools.clustering.method.value.WekaCobWebMethod;
import org.gitools.clustering.method.value.WekaHCLMethod;
import org.gitools.clustering.method.value.WekaKmeansMethod;

public class ClusteringMethodFactory {
    private static final ClusteringMethodDescriptor[] DEFAULT_DESCRIPTORS = new ClusteringMethodDescriptor[]{new ClusteringMethodDescriptor("Clustering from annotations", "Cluster data instances according to a set of selected annotations", AnnPatClusteringMethod.class), new ClusteringMethodDescriptor("Agglomerative hierarchical clustering", "Cluster data instances according to classic agglomerative hierarchical clustering method", WekaHCLMethod.class), new ClusteringMethodDescriptor("K-means clustering", "Cluster data instances according to k-means clustering method", WekaKmeansMethod.class), new ClusteringMethodDescriptor("Cobweb clustering", "Cluster data instances according to cobweb clustering method", WekaCobWebMethod.class)};
    private static ClusteringMethodFactory instance;
    private List<ClusteringMethodDescriptor> descriptors = new ArrayList<ClusteringMethodDescriptor>();

    private ClusteringMethodFactory() {
        this.registerMethods(DEFAULT_DESCRIPTORS);
    }

    public static ClusteringMethodFactory getDefault() {
        if (instance == null) {
            instance = new ClusteringMethodFactory();
        }
        return instance;
    }

    public List<ClusteringMethodDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public final void registerMethods(ClusteringMethodDescriptor[] descriptors) {
        this.descriptors.addAll(Arrays.asList(descriptors));
    }

    public ClusteringMethod create(ClusteringMethodDescriptor descriptor) {
        Class<? extends ClusteringMethod> methodClass = descriptor.getMethodClass();
        try {
            Constructor<? extends ClusteringMethod> c = methodClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

