/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.analysis.overlapping;

import org.gitools.matrix.model.element.AttributeDef;

public class OverlappingResult {
    private int columnCount;
    private int rowCount;
    private int bothCount;
    private double columnOnlyProp;
    private double rowOnlyProp;
    private double columnIntersectionProp;
    private double rowIntersectionProp;
    private double jaccardIndex;
    private double maxIntersectionProp;

    public OverlappingResult() {
    }

    public OverlappingResult(int rowCount, int columnCount, int bothCount) {
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.bothCount = bothCount;
        this.calculateProportions();
    }

    @AttributeDef(id="column-count", name="Column count", description="Number of positive events in column condintion")
    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnPositiveCount) {
        this.columnCount = columnPositiveCount;
    }

    @AttributeDef(id="row-count", name="Row count", description="Number of positive events in row condintion")
    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowPositiveCount) {
        this.rowCount = rowPositiveCount;
    }

    @AttributeDef(id="both-count", name="Both count", description="Number of positive events in both condintions")
    public int getBothCount() {
        return this.bothCount;
    }

    public void setBothCount(int bothPositiveCount) {
        this.bothCount = bothPositiveCount;
    }

    @AttributeDef(id="column-only-prop", name="Column only proportion", description="Proportion of events only in column condition out of the union")
    public double getColumnOnlyProp() {
        return this.columnOnlyProp;
    }

    public void setColumnOnlyProp(double columnOnlyProp) {
        this.columnOnlyProp = columnOnlyProp;
    }

    @AttributeDef(id="row-only-prop", name="Row only proportion", description="Proportion of events only in row condition out of the union")
    public double getRowOnlyProp() {
        return this.rowOnlyProp;
    }

    public void setRowOnlyProp(double rowOnlyProp) {
        this.rowOnlyProp = rowOnlyProp;
    }

    @AttributeDef(id="column-intersection-prop", name="Column intersection proportion", description="Proportion of shared events in column condition")
    public double getColumnIntersectionProp() {
        return this.columnIntersectionProp;
    }

    public void setColumnIntersectionProp(double columnIntersectionProp) {
        this.columnIntersectionProp = columnIntersectionProp;
    }

    @AttributeDef(id="row-intersection-prop", name="Row intersection proportion", description="Proportion of shared events in row condition")
    public double getRowIntersectionProp() {
        return this.rowIntersectionProp;
    }

    public void setRowIntersectionProp(double rowIntersectionProp) {
        this.rowIntersectionProp = rowIntersectionProp;
    }

    @AttributeDef(id="max-intersection-prop", name="Maximum intersection proportion", description="Maximum proportion of shared events")
    public double getMaxIntersectionProp() {
        return this.maxIntersectionProp;
    }

    public void setMaxIntersectionProp(double maxIntersectionProp) {
        this.maxIntersectionProp = maxIntersectionProp;
    }

    @AttributeDef(id="jaccard-index", name="Jaccard index", description="Proportion of shared events in both conditions")
    public double getJaccardIndex() {
        return this.jaccardIndex;
    }

    public void setJaccardIndex(double jaccardIndex) {
        this.jaccardIndex = jaccardIndex;
    }

    public final void calculateProportions() {
        double union = this.columnCount + this.rowCount - this.bothCount;
        double minCount = Math.min(this.columnCount, this.rowCount);
        this.columnOnlyProp = (double)this.columnCount / union;
        this.rowOnlyProp = (double)this.rowCount / union;
        this.columnIntersectionProp = this.columnCount != 0 ? (double)this.bothCount / (double)this.columnCount : 0.0;
        this.rowIntersectionProp = this.rowCount != 0 ? (double)this.bothCount / (double)this.rowCount : 0.0;
        this.maxIntersectionProp = minCount != 0.0 ? (double)this.bothCount / minCount : 0.0;
        this.jaccardIndex = union != 0.0 ? (double)this.bothCount / union : 0.0;
    }
}

